/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.auth;

import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.apache.pulsar.broker.authentication.AuthenticationDataSource;
import org.apache.pulsar.client.impl.auth.AuthenticationToken;
import org.apache.pulsar.functions.auth.FunctionAuthData;
import org.apache.pulsar.functions.auth.KubernetesFunctionAuthProvider;
import org.apache.pulsar.functions.instance.AuthenticationConfig;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.apis.CoreV1Api;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1Container;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1KeyToPath;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1PodSpec;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1ProjectedVolumeSource;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1SecretVolumeSource;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1ServiceAccountTokenProjection;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1StatefulSet;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1Volume;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1VolumeMount;
import org.apache.pulsar.functions.runtime.shaded.io.kubernetes.client.openapi.models.V1VolumeProjection;
import org.apache.pulsar.functions.runtime.shaded.org.eclipse.jetty.util.StringUtil;

public class KubernetesServiceAccountTokenAuthProvider
implements KubernetesFunctionAuthProvider {
    private static final String BROKER_CLIENT_TRUST_CERTS_SECRET_NAME = "brokerClientTrustCertsSecretName";
    private static final String SERVICE_ACCOUNT_TOKEN_EXPIRATION_SECONDS = "serviceAccountTokenExpirationSeconds";
    private static final String SERVICE_ACCOUNT_TOKEN_AUDIENCE = "serviceAccountTokenAudience";
    private static final String SERVICE_ACCOUNT_VOLUME_NAME = "service-account-token";
    private static final String TRUST_CERT_VOLUME_NAME = "ca-cert";
    private static final String DEFAULT_MOUNT_DIR = "/etc/auth";
    private static final String FUNCTION_AUTH_TOKEN = "token";
    private static final String FUNCTION_CA_CERT = "ca.crt";
    private static final String DEFAULT_CERT_PATH = "/etc/auth/ca.crt";
    private String brokerTrustCertsSecretName;
    private long serviceAccountTokenExpirationSeconds;
    private String serviceAccountTokenAudience;

    @Override
    public void initialize(CoreV1Api coreClient, byte[] caBytes, Function<Function.FunctionDetails, String> namespaceCustomizerFunc, Map<String, Object> config) {
        this.setNamespaceProviderFunc(namespaceCustomizerFunc);
        Object certSecretName = config.get(BROKER_CLIENT_TRUST_CERTS_SECRET_NAME);
        if (certSecretName instanceof String) {
            this.brokerTrustCertsSecretName = (String)certSecretName;
        } else if (certSecretName != null) {
            throw new IllegalArgumentException("Invalid value for brokerClientTrustCertsSecretName. Expected a string.");
        }
        Object tokenExpirationSeconds = config.get(SERVICE_ACCOUNT_TOKEN_EXPIRATION_SECONDS);
        if (tokenExpirationSeconds instanceof Long) {
            this.serviceAccountTokenExpirationSeconds = (Long)tokenExpirationSeconds;
        } else if (tokenExpirationSeconds instanceof String) {
            try {
                this.serviceAccountTokenExpirationSeconds = Long.parseLong((String)tokenExpirationSeconds);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid value for serviceAccountTokenExpirationSeconds. Expected a long.");
            }
        } else if (tokenExpirationSeconds != null) {
            throw new IllegalArgumentException("Invalid value for serviceAccountTokenExpirationSeconds. Expected a long.");
        }
        Object tokenAudience = config.get(SERVICE_ACCOUNT_TOKEN_AUDIENCE);
        if (tokenAudience instanceof String) {
            this.serviceAccountTokenAudience = (String)tokenAudience;
        } else if (tokenAudience != null) {
            throw new IllegalArgumentException("Invalid value for serviceAccountTokenAudience. Expected a string.");
        }
    }

    @Override
    public void configureAuthenticationConfig(AuthenticationConfig authConfig, Optional<FunctionAuthData> functionAuthData) {
        authConfig.setClientAuthenticationPlugin(AuthenticationToken.class.getName());
        authConfig.setClientAuthenticationParameters(Paths.get(DEFAULT_MOUNT_DIR, FUNCTION_AUTH_TOKEN).toUri().toString());
        if (StringUtil.isNotBlank(this.brokerTrustCertsSecretName)) {
            authConfig.setTlsTrustCertsFilePath(DEFAULT_CERT_PATH);
        }
    }

    @Override
    public Optional<FunctionAuthData> cacheAuthData(Function.FunctionDetails funcDetails, AuthenticationDataSource authenticationDataSource) throws Exception {
        return Optional.empty();
    }

    @Override
    public Optional<FunctionAuthData> updateAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> existingFunctionAuthData, AuthenticationDataSource authenticationDataSource) throws Exception {
        return Optional.empty();
    }

    @Override
    public void cleanUpAuthData(Function.FunctionDetails funcDetails, Optional<FunctionAuthData> functionAuthData) throws Exception {
    }

    @Override
    public void initialize(CoreV1Api coreClient) {
    }

    @Override
    public void configureAuthDataStatefulSet(V1StatefulSet statefulSet, Optional<FunctionAuthData> functionAuthData) {
        V1PodSpec podSpec = statefulSet.getSpec().getTemplate().getSpec();
        if (StringUtil.isNotBlank(this.brokerTrustCertsSecretName)) {
            podSpec.addVolumesItem(this.createTrustCertVolume());
        }
        podSpec.addVolumesItem(this.createServiceAccountVolume());
        podSpec.getContainers().forEach(this::addVolumeMountsToContainer);
    }

    private V1Volume createServiceAccountVolume() {
        V1ProjectedVolumeSource projectedVolumeSource = new V1ProjectedVolumeSource();
        V1VolumeProjection volumeProjection = new V1VolumeProjection();
        volumeProjection.serviceAccountToken(new V1ServiceAccountTokenProjection().audience(this.serviceAccountTokenAudience).expirationSeconds(Long.valueOf(this.serviceAccountTokenExpirationSeconds)).path(FUNCTION_AUTH_TOKEN));
        projectedVolumeSource.addSourcesItem(volumeProjection);
        return new V1Volume().name(SERVICE_ACCOUNT_VOLUME_NAME).projected(projectedVolumeSource);
    }

    private V1Volume createTrustCertVolume() {
        return new V1Volume().name(TRUST_CERT_VOLUME_NAME).secret(new V1SecretVolumeSource().secretName(this.brokerTrustCertsSecretName).addItemsItem(new V1KeyToPath().key(FUNCTION_CA_CERT).path(FUNCTION_CA_CERT)));
    }

    private void addVolumeMountsToContainer(V1Container container) {
        container.addVolumeMountsItem(new V1VolumeMount().name(SERVICE_ACCOUNT_VOLUME_NAME).mountPath(DEFAULT_MOUNT_DIR).readOnly(Boolean.valueOf(true)));
        if (StringUtil.isNotBlank(this.brokerTrustCertsSecretName)) {
            container.addVolumeMountsItem(new V1VolumeMount().name(TRUST_CERT_VOLUME_NAME).mountPath(DEFAULT_MOUNT_DIR).readOnly(Boolean.valueOf(true)));
        }
    }
}

