/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.instance;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.BatcherBuilder;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.client.api.CryptoKeyReader;
import org.apache.pulsar.client.api.HashingScheme;
import org.apache.pulsar.client.api.MessageRoutingMode;
import org.apache.pulsar.client.api.ProducerBuilder;
import org.apache.pulsar.client.api.ProducerCryptoFailureAction;
import org.apache.pulsar.client.api.PulsarClient;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.functions.CryptoConfig;
import org.apache.pulsar.common.functions.ProducerConfig;
import org.apache.pulsar.functions.instance.FunctionResultRouter;
import org.apache.pulsar.functions.runtime.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.functions.runtime.shaded.org.apache.commons.lang.StringUtils;
import org.apache.pulsar.functions.utils.CryptoUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerBuilderFactory {
    private static final Logger log = LoggerFactory.getLogger(ProducerBuilderFactory.class);
    private final PulsarClient client;
    private final ProducerConfig producerConfig;
    private final Consumer<ProducerBuilder<?>> defaultConfigurer;
    private final Crypto crypto;

    public ProducerBuilderFactory(PulsarClient client, ProducerConfig producerConfig, ClassLoader functionClassLoader, Consumer<ProducerBuilder<?>> defaultConfigurer) {
        this.client = client;
        this.producerConfig = producerConfig;
        this.defaultConfigurer = defaultConfigurer;
        try {
            this.crypto = this.initializeCrypto(functionClassLoader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to initialize crypto config " + producerConfig.getCryptoConfig(), e);
        }
        if (this.crypto == null) {
            log.info("crypto key reader is not provided, not enabling end to end encryption");
        }
    }

    public <T> ProducerBuilder<T> createProducerBuilder(String topic, Schema<T> schema, String producerName) {
        ProducerBuilder<T> builder = this.client.newProducer(schema);
        if (this.defaultConfigurer != null) {
            this.defaultConfigurer.accept(builder);
        }
        builder.blockIfQueueFull(true).enableBatching(true).batchingMaxPublishDelay(10L, TimeUnit.MILLISECONDS).hashingScheme(HashingScheme.Murmur3_32Hash).messageRoutingMode(MessageRoutingMode.CustomPartition).messageRouter(FunctionResultRouter.of()).sendTimeout(0, TimeUnit.SECONDS).topic(topic);
        if (producerName != null) {
            builder.producerName(producerName);
        }
        if (this.producerConfig != null) {
            if (this.producerConfig.getCompressionType() != null) {
                builder.compressionType(this.producerConfig.getCompressionType());
            } else {
                builder.compressionType(CompressionType.LZ4);
            }
            if (this.producerConfig.getMaxPendingMessages() != null && this.producerConfig.getMaxPendingMessages() != 0) {
                builder.maxPendingMessages(this.producerConfig.getMaxPendingMessages());
            }
            if (this.producerConfig.getMaxPendingMessagesAcrossPartitions() != null && this.producerConfig.getMaxPendingMessagesAcrossPartitions() != 0) {
                builder.maxPendingMessagesAcrossPartitions(this.producerConfig.getMaxPendingMessagesAcrossPartitions());
            }
            if (this.producerConfig.getCryptoConfig() != null) {
                builder.cryptoKeyReader(this.crypto.keyReader);
                builder.cryptoFailureAction(this.crypto.failureAction);
                for (String encryptionKeyName : this.crypto.getEncryptionKeys()) {
                    builder.addEncryptionKey(encryptionKeyName);
                }
            }
            if (this.producerConfig.getBatchBuilder() != null) {
                if (this.producerConfig.getBatchBuilder().equals("KEY_BASED")) {
                    builder.batcherBuilder(BatcherBuilder.KEY_BASED);
                } else {
                    builder.batcherBuilder(BatcherBuilder.DEFAULT);
                }
            }
        }
        return builder;
    }

    @VisibleForTesting
    Crypto initializeCrypto(ClassLoader functionClassLoader) throws ClassNotFoundException {
        if (this.producerConfig == null || this.producerConfig.getCryptoConfig() == null || StringUtils.isEmpty(this.producerConfig.getCryptoConfig().getCryptoKeyReaderClassName())) {
            return null;
        }
        CryptoConfig cryptoConfig = this.producerConfig.getCryptoConfig();
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        String[] encryptionKeys = cryptoConfig.getEncryptionKeys();
        Crypto.CryptoBuilder bldr = Crypto.builder().failureAction(cryptoConfig.getProducerCryptoFailureAction()).encryptionKeys(encryptionKeys);
        bldr.keyReader(CryptoUtils.getCryptoKeyReaderInstance(cryptoConfig.getCryptoKeyReaderClassName(), cryptoConfig.getCryptoKeyReaderConfig(), functionClassLoader));
        return bldr.build();
    }

    private static class Crypto {
        private CryptoKeyReader keyReader;
        private ProducerCryptoFailureAction failureAction;
        private String[] encryptionKeys;

        Crypto(CryptoKeyReader keyReader, ProducerCryptoFailureAction failureAction, String[] encryptionKeys) {
            this.keyReader = keyReader;
            this.failureAction = failureAction;
            this.encryptionKeys = encryptionKeys;
        }

        public static CryptoBuilder builder() {
            return new CryptoBuilder();
        }

        public CryptoKeyReader getKeyReader() {
            return this.keyReader;
        }

        public ProducerCryptoFailureAction getFailureAction() {
            return this.failureAction;
        }

        public String[] getEncryptionKeys() {
            return this.encryptionKeys;
        }

        public void setKeyReader(CryptoKeyReader keyReader) {
            this.keyReader = keyReader;
        }

        public void setFailureAction(ProducerCryptoFailureAction failureAction) {
            this.failureAction = failureAction;
        }

        public void setEncryptionKeys(String[] encryptionKeys) {
            this.encryptionKeys = encryptionKeys;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Crypto)) {
                return false;
            }
            Crypto other = (Crypto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CryptoKeyReader this$keyReader = this.getKeyReader();
            CryptoKeyReader other$keyReader = other.getKeyReader();
            if (this$keyReader == null ? other$keyReader != null : !this$keyReader.equals(other$keyReader)) {
                return false;
            }
            ProducerCryptoFailureAction this$failureAction = this.getFailureAction();
            ProducerCryptoFailureAction other$failureAction = other.getFailureAction();
            if (this$failureAction == null ? other$failureAction != null : !((Object)((Object)this$failureAction)).equals((Object)other$failureAction)) {
                return false;
            }
            return Arrays.deepEquals(this.getEncryptionKeys(), other.getEncryptionKeys());
        }

        protected boolean canEqual(Object other) {
            return other instanceof Crypto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CryptoKeyReader $keyReader = this.getKeyReader();
            result = result * 59 + ($keyReader == null ? 43 : $keyReader.hashCode());
            ProducerCryptoFailureAction $failureAction = this.getFailureAction();
            result = result * 59 + ($failureAction == null ? 43 : ((Object)((Object)$failureAction)).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getEncryptionKeys());
            return result;
        }

        public String toString() {
            return "ProducerBuilderFactory.Crypto(keyReader=" + this.getKeyReader() + ", failureAction=" + this.getFailureAction() + ", encryptionKeys=" + Arrays.deepToString(this.getEncryptionKeys()) + ")";
        }

        public static class CryptoBuilder {
            private CryptoKeyReader keyReader;
            private ProducerCryptoFailureAction failureAction;
            private String[] encryptionKeys;

            CryptoBuilder() {
            }

            public CryptoBuilder keyReader(CryptoKeyReader keyReader) {
                this.keyReader = keyReader;
                return this;
            }

            public CryptoBuilder failureAction(ProducerCryptoFailureAction failureAction) {
                this.failureAction = failureAction;
                return this;
            }

            public CryptoBuilder encryptionKeys(String[] encryptionKeys) {
                this.encryptionKeys = encryptionKeys;
                return this;
            }

            public Crypto build() {
                return new Crypto(this.keyReader, this.failureAction, this.encryptionKeys);
            }

            public String toString() {
                return "ProducerBuilderFactory.Crypto.CryptoBuilder(keyReader=" + this.keyReader + ", failureAction=" + this.failureAction + ", encryptionKeys=" + Arrays.deepToString(this.encryptionKeys) + ")";
            }
        }
    }
}

