/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.coder;

import java.io.Serializable;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.Unpooled;

public interface Coder<T>
extends Serializable {
    default public ByteBuf encodeBuf(T value) {
        int len = this.getSerializedSize(value);
        ByteBuf buffer = Unpooled.buffer(len, len);
        buffer.setIndex(0, 0);
        this.encode(value, buffer);
        return buffer;
    }

    default public byte[] encode(T value) {
        byte[] data = new byte[this.getSerializedSize(value)];
        ByteBuf buf = Unpooled.wrappedBuffer(data);
        buf.setIndex(0, 0);
        this.encode(value, buf);
        return data;
    }

    public void encode(T var1, ByteBuf var2);

    public int getSerializedSize(T var1);

    public T decode(ByteBuf var1);

    default public T decode(byte[] data) {
        return this.decode(Unpooled.wrappedBuffer(data));
    }
}

