/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum;

import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBuf;
import org.apache.pulsar.functions.runtime.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.pulsar.functions.runtime.shaded.io.netty.util.concurrent.FastThreadLocal;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.DirectMemoryCRC32Digest;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.proto.checksum.StandardCRC32Digest;

class CRC32DigestManager
extends DigestManager {
    private static final FastThreadLocal<CRC32Digest> crc = new FastThreadLocal<CRC32Digest>(){

        @Override
        protected CRC32Digest initialValue() {
            if (DirectMemoryCRC32Digest.isSupported()) {
                return new DirectMemoryCRC32Digest();
            }
            return new StandardCRC32Digest();
        }
    };

    public CRC32DigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
    }

    @Override
    int getMacCodeLength() {
        return 8;
    }

    @Override
    void populateValueAndReset(int digest, ByteBuf buf) {
        buf.writeLong(crc.get().getValueAndReset());
    }

    @Override
    int internalUpdate(int digest, ByteBuf data, int offset, int len) {
        crc.get().update(data, offset, len);
        return 0;
    }

    @Override
    int internalUpdate(int digest, byte[] buffer, int offset, int len) {
        crc.get().update(buffer, offset, len);
        return 0;
    }

    @Override
    boolean isInt32Digest() {
        return false;
    }

    @Override
    boolean acceptsMemoryAddressBuffer() {
        return DirectMemoryCRC32Digest.isSupported();
    }

    static interface CRC32Digest {
        public long getValueAndReset();

        public void update(ByteBuf var1, int var2, int var3);

        public void update(byte[] var1, int var2, int var3);
    }
}

