/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.util;

import java.io.FileDescriptor;
import java.lang.reflect.Field;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.nativeio.NativeIO;
import org.apache.pulsar.functions.runtime.shaded.org.apache.bookkeeper.common.util.nativeio.NativeIOImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageCacheUtil {
    private static final Logger log = LoggerFactory.getLogger(PageCacheUtil.class);
    private static final int POSIX_FADV_DONTNEED = 4;
    private static boolean fadvisePossible = true;
    private static final NativeIO NATIVE_IO;

    private static Field getFieldByReflection(Class cls, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = cls.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (Exception e) {
                log.warn("Unable to read {} field from {}", (Object)fieldName, (Object)cls.getName());
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return field;
    }

    public static int getSysFileDescriptor(FileDescriptor descriptor) {
        Field field = PageCacheUtil.getFieldByReflection(descriptor.getClass(), "fd");
        try {
            return field.getInt(descriptor);
        }
        catch (Exception e) {
            log.warn("Unable to read fd field from java.io.FileDescriptor");
            return -1;
        }
    }

    public static void bestEffortRemoveFromPageCache(int fd, long offset, long len) {
        if (!fadvisePossible || fd < 0) {
            return;
        }
        try {
            NATIVE_IO.posix_fadvise(fd, offset, len, 4);
        }
        catch (Throwable e) {
            log.warn("Failed to perform posix_fadvise: {}", (Object)e.getMessage());
            fadvisePossible = false;
        }
    }

    private PageCacheUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        NativeIOImpl nativeIO = null;
        try {
            nativeIO = new NativeIOImpl();
        }
        catch (Exception e) {
            log.warn("Unable to initialize NativeIO for posix_fdavise: {}", (Object)e.getMessage());
            fadvisePossible = false;
        }
        NATIVE_IO = nativeIO;
    }
}

