/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.runtime.shaded.org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import org.apache.pulsar.functions.runtime.shaded.org.eclipse.jetty.util.BufferUtil;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    default public void remove(ByteBuffer buffer) {
    }

    default public ByteBuffer newByteBuffer(int capacity, boolean direct) {
        return direct ? BufferUtil.allocateDirect(capacity) : BufferUtil.allocate(capacity);
    }

    public static class Bucket {
        private final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();
        private final ByteBufferPool _pool;
        private final int _capacity;
        private final int _maxSize;
        private final AtomicInteger _size;
        private final AtomicLong _lastUpdate = new AtomicLong(System.nanoTime());
        private final IntConsumer _memoryFunction;

        @Deprecated
        public Bucket(ByteBufferPool pool, int capacity, int maxSize) {
            this(pool, capacity, maxSize, i -> {});
        }

        public Bucket(ByteBufferPool pool, int capacity, int maxSize, IntConsumer memoryFunction) {
            this._pool = pool;
            this._capacity = capacity;
            this._maxSize = maxSize;
            this._size = maxSize > 0 ? new AtomicInteger() : null;
            this._memoryFunction = Objects.requireNonNull(memoryFunction);
        }

        public ByteBuffer acquire() {
            ByteBuffer buffer = this._queue.poll();
            if (buffer != null) {
                if (this._size != null) {
                    this._size.decrementAndGet();
                }
                this._memoryFunction.accept(-buffer.capacity());
            }
            return buffer;
        }

        @Deprecated
        public ByteBuffer acquire(boolean direct) {
            ByteBuffer buffer = this.acquire();
            if (buffer == null) {
                return this._pool.newByteBuffer(this._capacity, direct);
            }
            return buffer;
        }

        public void release(ByteBuffer buffer) {
            this.resetUpdateTime();
            BufferUtil.reset(buffer);
            if (this._size == null || this._size.incrementAndGet() <= this._maxSize) {
                this._queue.offer(buffer);
                this._memoryFunction.accept(buffer.capacity());
            } else {
                this._size.decrementAndGet();
            }
        }

        void resetUpdateTime() {
            this._lastUpdate.lazySet(System.nanoTime());
        }

        public void clear() {
            ByteBuffer buffer;
            int size;
            int n = size = this._size == null ? 0 : this._size.get() - 1;
            while (size >= 0 && (buffer = this.acquire()) != null) {
                if (this._size == null) continue;
                --size;
            }
        }

        boolean isEmpty() {
            return this._queue.isEmpty();
        }

        int size() {
            return this._queue.size();
        }

        long getLastUpdate() {
            return this._lastUpdate.get();
        }

        public String toString() {
            return String.format("%s@%x{capacity=%d, size=%d, maxSize=%d}", this.getClass().getSimpleName(), this.hashCode(), this._capacity, this.size(), this._maxSize);
        }
    }

    public static class Lease {
        private final ByteBufferPool byteBufferPool;
        private final List<ByteBuffer> buffers;
        private final List<Boolean> recycles;

        public Lease(ByteBufferPool byteBufferPool) {
            this.byteBufferPool = byteBufferPool;
            this.buffers = new ArrayList<ByteBuffer>();
            this.recycles = new ArrayList<Boolean>();
        }

        public ByteBuffer acquire(int capacity, boolean direct) {
            ByteBuffer buffer = this.byteBufferPool.acquire(capacity, direct);
            BufferUtil.clearToFill(buffer);
            return buffer;
        }

        public void append(ByteBuffer buffer, boolean recycle) {
            this.buffers.add(buffer);
            this.recycles.add(recycle);
        }

        public void insert(int index, ByteBuffer buffer, boolean recycle) {
            this.buffers.add(index, buffer);
            this.recycles.add(index, recycle);
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.buffers;
        }

        public long getTotalLength() {
            long length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                length += (long)buffer.remaining();
            }
            return length;
        }

        public int getSize() {
            return this.buffers.size();
        }

        public void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                ByteBuffer buffer = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.release(buffer);
            }
            this.buffers.clear();
            this.recycles.clear();
        }

        public void release(ByteBuffer buffer) {
            this.byteBufferPool.release(buffer);
        }
    }
}

