/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.utils;

public class FunctionInstanceId {
    private String tenant;
    private String namespace;
    private String name;
    private int instanceId;

    public FunctionInstanceId(String fullyQualifiedInstanceName) {
        String[] t1 = fullyQualifiedInstanceName.split("/");
        if (t1.length != 3) {
            throw new IllegalArgumentException("Invalid format for fully qualified instance name: " + fullyQualifiedInstanceName);
        }
        this.tenant = t1[0];
        this.namespace = t1[1];
        int instanceIdDelimiterIndex = t1[2].lastIndexOf(58);
        if (instanceIdDelimiterIndex < 0) {
            throw new IllegalArgumentException("Invalid format for fully qualified instance name: " + fullyQualifiedInstanceName);
        }
        this.name = t1[2].substring(0, instanceIdDelimiterIndex);
        this.instanceId = Integer.parseInt(t1[2].substring(instanceIdDelimiterIndex + 1));
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setInstanceId(int instanceId) {
        this.instanceId = instanceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionInstanceId)) {
            return false;
        }
        FunctionInstanceId other = (FunctionInstanceId)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInstanceId() != other.getInstanceId()) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FunctionInstanceId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getInstanceId();
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "FunctionInstanceId(tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", instanceId=" + this.getInstanceId() + ")";
    }
}

