/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class ElasticSearchConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The url of elastic search cluster that the connector connects to")
    private String elasticSearchUrl;
    @FieldDoc(required=true, defaultValue="", help="The index name that the connector writes messages to")
    private String indexName;
    @FieldDoc(required=false, defaultValue="_doc", help="The type name that the connector writes messages to, with the default value set to _doc. This value should be set explicitly to a valid type name other than _doc for Elasticsearch version before 6.2, and left to the default value otherwise.")
    private String typeName = "_doc";
    @FieldDoc(required=false, defaultValue="1", help="The number of shards of the index")
    private int indexNumberOfShards = 1;
    @FieldDoc(required=false, defaultValue="1", help="The number of replicas of the index")
    private int indexNumberOfReplicas = 1;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The username used by the connector to connect to the elastic search cluster. If username is set, a password should also be provided.")
    private String username;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The password used by the connector to connect to the elastic search cluster. If password is set, a username should also be provided")
    private String password;

    public static ElasticSearchConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (ElasticSearchConfig)mapper.readValue(new File(yamlFile), ElasticSearchConfig.class);
    }

    public static ElasticSearchConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (ElasticSearchConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), ElasticSearchConfig.class);
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.elasticSearchUrl) || StringUtils.isEmpty((CharSequence)this.indexName)) {
            throw new IllegalArgumentException("Required property not set.");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.username) && StringUtils.isEmpty((CharSequence)this.password) || StringUtils.isEmpty((CharSequence)this.username) && StringUtils.isNotEmpty((CharSequence)this.password)) {
            throw new IllegalArgumentException("Values for both Username & password are required.");
        }
        if (this.indexNumberOfShards < 1) {
            throw new IllegalArgumentException("indexNumberOfShards must be a strictly positive integer");
        }
        if (this.indexNumberOfReplicas < 0) {
            throw new IllegalArgumentException("indexNumberOfReplicas must be a positive integer");
        }
    }

    public String getElasticSearchUrl() {
        return this.elasticSearchUrl;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getIndexNumberOfShards() {
        return this.indexNumberOfShards;
    }

    public int getIndexNumberOfReplicas() {
        return this.indexNumberOfReplicas;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public ElasticSearchConfig setElasticSearchUrl(String elasticSearchUrl) {
        this.elasticSearchUrl = elasticSearchUrl;
        return this;
    }

    public ElasticSearchConfig setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ElasticSearchConfig setTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    public ElasticSearchConfig setIndexNumberOfShards(int indexNumberOfShards) {
        this.indexNumberOfShards = indexNumberOfShards;
        return this;
    }

    public ElasticSearchConfig setIndexNumberOfReplicas(int indexNumberOfReplicas) {
        this.indexNumberOfReplicas = indexNumberOfReplicas;
        return this;
    }

    public ElasticSearchConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public ElasticSearchConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticSearchConfig)) {
            return false;
        }
        ElasticSearchConfig other = (ElasticSearchConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndexNumberOfShards() != other.getIndexNumberOfShards()) {
            return false;
        }
        if (this.getIndexNumberOfReplicas() != other.getIndexNumberOfReplicas()) {
            return false;
        }
        String this$elasticSearchUrl = this.getElasticSearchUrl();
        String other$elasticSearchUrl = other.getElasticSearchUrl();
        if (this$elasticSearchUrl == null ? other$elasticSearchUrl != null : !this$elasticSearchUrl.equals(other$elasticSearchUrl)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$typeName = this.getTypeName();
        String other$typeName = other.getTypeName();
        if (this$typeName == null ? other$typeName != null : !this$typeName.equals(other$typeName)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticSearchConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndexNumberOfShards();
        result = result * 59 + this.getIndexNumberOfReplicas();
        String $elasticSearchUrl = this.getElasticSearchUrl();
        result = result * 59 + ($elasticSearchUrl == null ? 43 : $elasticSearchUrl.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $typeName = this.getTypeName();
        result = result * 59 + ($typeName == null ? 43 : $typeName.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "ElasticSearchConfig(elasticSearchUrl=" + this.getElasticSearchUrl() + ", indexName=" + this.getIndexName() + ", typeName=" + this.getTypeName() + ", indexNumberOfShards=" + this.getIndexNumberOfShards() + ", indexNumberOfReplicas=" + this.getIndexNumberOfReplicas() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

