/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.conn.PoolingNHttpClientConnectionManager;
import org.apache.http.impl.nio.reactor.DefaultConnectingIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.conn.NHttpClientConnectionManager;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.nio.reactor.ConnectingIOReactor;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.pulsar.client.api.schema.GenericObject;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConfig;
import org.apache.pulsar.io.elasticsearch.ElasticSearchConnectionException;
import org.apache.pulsar.io.elasticsearch.ElasticSearchSslConfig;
import org.apache.pulsar.io.elasticsearch.RandomExponentialBackoffPolicy;
import org.apache.pulsar.io.elasticsearch.RandomExponentialRetry;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Node;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchClient.class);
    static final String[] malformedErrors = new String[]{"mapper_parsing_exception", "action_request_validation_exception", "illegal_argument_exception"};
    private ElasticSearchConfig config;
    private ConfigCallback configCallback;
    private RestHighLevelClient client;
    final Set<String> indexCache = new HashSet<String>();
    final Map<String, String> topicToIndexCache = new HashMap<String, String>();
    final RandomExponentialRetry backoffRetry;
    final BulkProcessor bulkProcessor;
    final ConcurrentMap<DocWriteRequest<?>, Record> records = new ConcurrentHashMap();
    final AtomicReference<Exception> irrecoverableError = new AtomicReference();
    final ScheduledExecutorService executorService;

    ElasticSearchClient(ElasticSearchConfig elasticSearchConfig) {
        this.config = elasticSearchConfig;
        this.configCallback = new ConfigCallback();
        this.backoffRetry = new RandomExponentialRetry(elasticSearchConfig.getMaxRetryTimeInSec());
        if (!this.config.isBulkEnabled()) {
            this.bulkProcessor = null;
        } else {
            BulkProcessor.Builder builder = BulkProcessor.builder((bulkRequest, bulkResponseActionListener) -> this.client.bulkAsync(bulkRequest, RequestOptions.DEFAULT, bulkResponseActionListener), (BulkProcessor.Listener)new BulkProcessor.Listener(){

                public void beforeBulk(long l, BulkRequest bulkRequest) {
                }

                public void afterBulk(long l, BulkRequest bulkRequest, BulkResponse bulkResponse) {
                    log.trace("Bulk request id={} size={}:", (Object)l, (Object)bulkRequest.requests().size());
                    for (int i = 0; i < bulkResponse.getItems().length; ++i) {
                        DocWriteRequest request = (DocWriteRequest)bulkRequest.requests().get(i);
                        Record record = (Record)ElasticSearchClient.this.records.get(request);
                        BulkItemResponse bulkItemResponse = bulkResponse.getItems()[i];
                        if (bulkItemResponse.isFailed()) {
                            record.fail();
                            try {
                                ElasticSearchClient.this.hasIrrecoverableError(bulkItemResponse);
                            }
                            catch (Exception e) {
                                log.warn("Unrecoverable error:", (Throwable)e);
                            }
                        } else {
                            record.ack();
                        }
                        ElasticSearchClient.this.records.remove(request);
                    }
                }

                public void afterBulk(long l, BulkRequest bulkRequest, Throwable throwable) {
                    log.warn("Bulk request id={} failed:", (Object)l, (Object)throwable);
                    for (DocWriteRequest request : bulkRequest.requests()) {
                        Record record = (Record)ElasticSearchClient.this.records.remove(request);
                        record.fail();
                    }
                }
            }).setBulkActions(this.config.getBulkActions()).setBulkSize(new ByteSizeValue(this.config.getBulkSizeInMb(), ByteSizeUnit.MB)).setConcurrentRequests(this.config.getBulkConcurrentRequests()).setBackoffPolicy((BackoffPolicy)new RandomExponentialBackoffPolicy(this.backoffRetry, this.config.getRetryBackoffInMs(), this.config.getMaxRetries()));
            if (this.config.getBulkFlushIntervalInMs() > 0L) {
                builder.setFlushInterval(new TimeValue(this.config.getBulkFlushIntervalInMs(), TimeUnit.MILLISECONDS));
            }
            this.bulkProcessor = builder.build();
        }
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ((ElasticSearchClient)ElasticSearchClient.this).configCallback.connectionManager.closeExpiredConnections();
                ((ElasticSearchClient)ElasticSearchClient.this).configCallback.connectionManager.closeIdleConnections((long)ElasticSearchClient.this.config.getConnectionIdleTimeoutInMs(), TimeUnit.MILLISECONDS);
            }
        }, this.config.getConnectionIdleTimeoutInMs(), this.config.getConnectionIdleTimeoutInMs(), TimeUnit.MILLISECONDS);
        log.info("ElasticSearch URL {}", (Object)this.config.getElasticSearchUrl());
        HttpHost[] hosts = ElasticSearchClient.getHttpHosts(this.config);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts).setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

            public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder builder) {
                return builder.setContentCompressionEnabled(ElasticSearchClient.this.config.isCompressionEnabled()).setConnectionRequestTimeout(ElasticSearchClient.this.config.getConnectionRequestTimeoutInMs()).setConnectTimeout(ElasticSearchClient.this.config.getConnectTimeoutInMs()).setSocketTimeout(ElasticSearchClient.this.config.getSocketTimeoutInMs());
            }
        }).setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)this.configCallback).setFailureListener(new RestClient.FailureListener(){

            public void onFailure(Node node) {
                log.warn("Node host={} failed", (Object)node.getHost());
            }
        });
        this.client = new RestHighLevelClient(builder);
    }

    void failed(Exception e) throws Exception {
        if (this.irrecoverableError.compareAndSet(null, e)) {
            log.error("Irrecoverable error:", (Throwable)e);
        }
    }

    boolean isFailed() {
        return this.irrecoverableError.get() != null;
    }

    void hasIrrecoverableError(BulkItemResponse bulkItemResponse) throws Exception {
        block5: for (String error : malformedErrors) {
            if (!bulkItemResponse.getFailureMessage().contains(error)) continue;
            switch (this.config.getMalformedDocAction()) {
                case IGNORE: {
                    continue block5;
                }
                case WARN: {
                    log.warn("Ignoring malformed document index={} id={}", new Object[]{bulkItemResponse.getIndex(), bulkItemResponse.getId(), bulkItemResponse.getFailure().getCause()});
                    continue block5;
                }
                case FAIL: {
                    log.error("Failure due to the malformed document index={} id={}", new Object[]{bulkItemResponse.getIndex(), bulkItemResponse.getId(), bulkItemResponse.getFailure().getCause()});
                    this.failed(bulkItemResponse.getFailure().getCause());
                }
            }
        }
    }

    public void bulkIndex(Record record, Pair<String, String> idAndDoc) throws Exception {
        try {
            this.checkNotFailed();
            this.checkIndexExists(record.getTopicName());
            IndexRequest indexRequest = Requests.indexRequest((String)this.config.getIndexName());
            if (!Strings.isNullOrEmpty((String)((String)idAndDoc.getLeft()))) {
                indexRequest.id((String)idAndDoc.getLeft());
            }
            indexRequest.type(this.config.getTypeName());
            indexRequest.source((String)idAndDoc.getRight(), XContentType.JSON);
            this.records.put((DocWriteRequest<?>)indexRequest, record);
            this.bulkProcessor.add(indexRequest);
        }
        catch (Exception e) {
            log.debug("index failed id=" + (String)idAndDoc.getLeft(), (Throwable)e);
            record.fail();
            throw e;
        }
    }

    public boolean indexDocument(Record<GenericObject> record, Pair<String, String> idAndDoc) throws Exception {
        try {
            this.checkNotFailed();
            this.checkIndexExists(record.getTopicName());
            IndexRequest indexRequest = Requests.indexRequest((String)this.config.getIndexName());
            if (!Strings.isNullOrEmpty((String)((String)idAndDoc.getLeft()))) {
                indexRequest.id((String)idAndDoc.getLeft());
            }
            indexRequest.type(this.config.getTypeName());
            indexRequest.source((String)idAndDoc.getRight(), XContentType.JSON);
            IndexResponse indexResponse = this.client.index(indexRequest, RequestOptions.DEFAULT);
            if (indexResponse.getResult().equals((Object)DocWriteResponse.Result.CREATED) || indexResponse.getResult().equals((Object)DocWriteResponse.Result.UPDATED)) {
                record.ack();
                return true;
            }
            record.fail();
            return false;
        }
        catch (Exception ex) {
            log.error("index failed id=" + (String)idAndDoc.getLeft(), (Throwable)ex);
            record.fail();
            throw ex;
        }
    }

    public void bulkDelete(Record<GenericObject> record, String id) throws Exception {
        try {
            this.checkNotFailed();
            this.checkIndexExists(record.getTopicName());
            DeleteRequest deleteRequest = Requests.deleteRequest((String)this.config.getIndexName());
            deleteRequest.id(id);
            deleteRequest.type(this.config.getTypeName());
            this.records.put((DocWriteRequest<?>)deleteRequest, (Record)record);
            this.bulkProcessor.add(deleteRequest);
        }
        catch (Exception e) {
            log.debug("delete failed id=" + id, (Throwable)e);
            record.fail();
            throw e;
        }
    }

    public boolean deleteDocument(Record<GenericObject> record, String id) throws Exception {
        try {
            this.checkNotFailed();
            this.checkIndexExists(record.getTopicName());
            DeleteRequest deleteRequest = Requests.deleteRequest((String)this.config.getIndexName());
            deleteRequest.id(id);
            deleteRequest.type(this.config.getTypeName());
            DeleteResponse deleteResponse = this.client.delete(deleteRequest, RequestOptions.DEFAULT);
            log.debug("delete result=" + deleteResponse.getResult());
            if (deleteResponse.getResult().equals((Object)DocWriteResponse.Result.DELETED) || deleteResponse.getResult().equals((Object)DocWriteResponse.Result.NOT_FOUND)) {
                record.ack();
                return true;
            }
            record.fail();
            return false;
        }
        catch (Exception ex) {
            log.debug("index failed id=" + id, (Throwable)ex);
            record.fail();
            throw ex;
        }
    }

    public void flush() {
        this.bulkProcessor.flush();
    }

    @Override
    public void close() {
        try {
            if (this.bulkProcessor != null) {
                this.bulkProcessor.awaitClose(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            log.warn("Elasticsearch bulk processor close error:", (Throwable)e);
        }
        try {
            this.executorService.shutdown();
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            log.warn("Elasticsearch client close error:", (Throwable)e);
        }
    }

    private void checkNotFailed() throws Exception {
        if (this.irrecoverableError.get() != null) {
            throw this.irrecoverableError.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIndexExists(Optional<String> topicName) throws IOException {
        if (!this.config.isCreateIndexIfNeeded()) {
            return;
        }
        String indexName = this.indexName(topicName);
        if (!this.indexCache.contains(indexName)) {
            ElasticSearchClient elasticSearchClient = this;
            synchronized (elasticSearchClient) {
                if (!this.indexCache.contains(indexName)) {
                    this.createIndexIfNeeded(indexName);
                    this.indexCache.add(indexName);
                }
            }
        }
    }

    private String indexName(Optional<String> topicName) throws IOException {
        if (this.config.getIndexName() != null) {
            return this.config.getIndexName();
        }
        if (!topicName.isPresent()) {
            throw new IOException("Elasticsearch index name configuration and topic name are empty");
        }
        return this.topicToIndexName(topicName.get());
    }

    @VisibleForTesting
    public String topicToIndexName(String topicName) {
        return this.topicToIndexCache.computeIfAbsent(topicName, k -> {
            String indexName = topicName.toLowerCase(Locale.ROOT);
            String[] parts = indexName.split("/");
            if (parts.length > 1) {
                indexName = parts[parts.length - 1];
            }
            while (indexName.getBytes(StandardCharsets.UTF_8).length > 255) {
                indexName = indexName.substring(0, indexName.length() - 1);
            }
            if (indexName.length() <= 0 || !indexName.matches("[a-zA-Z\\.0-9][a-zA-Z_\\.\\-\\+0-9]*")) {
                throw new RuntimeException(new IOException("Cannot convert the topic name='" + topicName + "' to a valid elasticsearch index name"));
            }
            if (log.isDebugEnabled()) {
                log.debug("Translate topic={} to index={}", k, (Object)indexName);
            }
            return indexName;
        });
    }

    @VisibleForTesting
    public boolean createIndexIfNeeded(String indexName) throws IOException {
        if (this.indexExists(indexName)) {
            return false;
        }
        CreateIndexRequest cireq = new CreateIndexRequest(indexName);
        cireq.settings(Settings.builder().put("index.number_of_shards", this.config.getIndexNumberOfShards()).put("index.number_of_replicas", this.config.getIndexNumberOfReplicas()));
        return this.retry(() -> {
            CreateIndexResponse resp = this.client.indices().create(cireq, RequestOptions.DEFAULT);
            if (!resp.isAcknowledged() || !resp.isShardsAcknowledged()) {
                throw new IOException("Unable to create index.");
            }
            return true;
        }, "create index");
    }

    public boolean indexExists(String indexName) throws IOException {
        GetIndexRequest request = new GetIndexRequest(new String[]{indexName});
        return this.retry(() -> this.client.indices().exists(request, RequestOptions.DEFAULT), "index exists");
    }

    @VisibleForTesting
    protected long totalHits(String indexName) throws IOException {
        return this.search((String)indexName).getHits().getTotalHits().value;
    }

    @VisibleForTesting
    protected SearchResponse search(String indexName) throws IOException {
        this.client.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
        return this.client.search(new SearchRequest().indices(new String[]{indexName}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.matchAllQuery())), RequestOptions.DEFAULT);
    }

    @VisibleForTesting
    protected RefreshResponse refresh(String indexName) throws IOException {
        return this.client.indices().refresh(new RefreshRequest(new String[]{indexName}), RequestOptions.DEFAULT);
    }

    @VisibleForTesting
    protected AcknowledgedResponse delete(String indexName) throws IOException {
        return this.client.indices().delete(new DeleteIndexRequest(indexName), RequestOptions.DEFAULT);
    }

    private <T> T retry(Callable<T> callable, String source) {
        try {
            return this.backoffRetry.retry(callable, this.config.getMaxRetries(), this.config.getRetryBackoffInMs(), source);
        }
        catch (Exception e) {
            log.error("error in command {} wth retry", (Object)source, (Object)e);
            throw new ElasticSearchConnectionException(source + " failed", e);
        }
    }

    private static HttpHost[] getHttpHosts(ElasticSearchConfig elasticSearchConfig) {
        String url = elasticSearchConfig.getElasticSearchUrl();
        return (HttpHost[])Arrays.stream(url.split(",")).map(host -> {
            try {
                URL hostUrl = new URL((String)host);
                return new HttpHost(hostUrl.getHost(), hostUrl.getPort(), hostUrl.getProtocol());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Invalid elasticSearch url :" + host);
            }
        }).toArray(HttpHost[]::new);
    }

    RestHighLevelClient getClient() {
        return this.client;
    }

    public class ConfigCallback
    implements RestClientBuilder.HttpClientConfigCallback {
        final NHttpClientConnectionManager connectionManager;
        final CredentialsProvider credentialsProvider;

        public ConfigCallback() {
            this.connectionManager = this.buildConnectionManager(ElasticSearchClient.this.config);
            this.credentialsProvider = this.buildCredentialsProvider(ElasticSearchClient.this.config);
        }

        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder builder) {
            builder.setMaxConnPerRoute(ElasticSearchClient.this.config.getBulkConcurrentRequests());
            builder.setMaxConnTotal(ElasticSearchClient.this.config.getBulkConcurrentRequests());
            builder.setConnectionManager(this.connectionManager);
            if (this.credentialsProvider != null) {
                builder.setDefaultCredentialsProvider(this.credentialsProvider);
            }
            return builder;
        }

        public NHttpClientConnectionManager buildConnectionManager(ElasticSearchConfig config) {
            try {
                PoolingNHttpClientConnectionManager connManager;
                IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setConnectTimeout(config.getConnectTimeoutInMs()).setSoTimeout(config.getSocketTimeoutInMs()).build();
                DefaultConnectingIOReactor ioReactor = new DefaultConnectingIOReactor(ioReactorConfig);
                if (config.getSsl().isEnabled()) {
                    ElasticSearchSslConfig sslConfig = config.getSsl();
                    HostnameVerifier hostnameVerifier = config.getSsl().isHostnameVerification() ? SSLConnectionSocketFactory.getDefaultHostnameVerifier() : new NoopHostnameVerifier();
                    String[] cipherSuites = null;
                    if (!Strings.isNullOrEmpty((String)sslConfig.getCipherSuites())) {
                        cipherSuites = sslConfig.getCipherSuites().split(",");
                    }
                    String[] protocols = null;
                    if (!Strings.isNullOrEmpty((String)sslConfig.getProtocols())) {
                        protocols = sslConfig.getProtocols().split(",");
                    }
                    Registry registry = RegistryBuilder.create().register("http", (Object)NoopIOSessionStrategy.INSTANCE).register("https", (Object)new SSLIOSessionStrategy(this.buildSslContext(config), protocols, cipherSuites, hostnameVerifier)).build();
                    connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor, registry);
                } else {
                    connManager = new PoolingNHttpClientConnectionManager((ConnectingIOReactor)ioReactor);
                }
                return connManager;
            }
            catch (Exception e) {
                throw new ElasticSearchConnectionException(e);
            }
        }

        private SSLContext buildSslContext(ElasticSearchConfig config) throws NoSuchAlgorithmException, KeyManagementException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
            ElasticSearchSslConfig sslConfig = config.getSsl();
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (!Strings.isNullOrEmpty((String)sslConfig.getProvider())) {
                sslContextBuilder.setProvider(sslConfig.getProvider());
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getProtocols())) {
                sslContextBuilder.setProtocol(sslConfig.getProtocols());
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getTruststorePath()) && !Strings.isNullOrEmpty((String)sslConfig.getTruststorePassword())) {
                sslContextBuilder.loadTrustMaterial(new File(sslConfig.getTruststorePath()), sslConfig.getTruststorePassword().toCharArray());
            }
            if (!Strings.isNullOrEmpty((String)sslConfig.getKeystorePath()) && !Strings.isNullOrEmpty((String)sslConfig.getKeystorePassword())) {
                sslContextBuilder.loadKeyMaterial(new File(sslConfig.getKeystorePath()), sslConfig.getKeystorePassword().toCharArray(), sslConfig.getKeystorePassword().toCharArray());
            }
            return sslContextBuilder.build();
        }

        private CredentialsProvider buildCredentialsProvider(ElasticSearchConfig config) {
            if (StringUtils.isEmpty((CharSequence)config.getUsername()) || StringUtils.isEmpty((CharSequence)config.getPassword())) {
                return null;
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
            return credentialsProvider;
        }
    }
}

