/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb.v2;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class InfluxDBSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="The url of the InfluxDB instance to connect to")
    private String influxdbUrl;
    @FieldDoc(required=true, defaultValue="", sensitive=true, help="The authentication token used to authenticate to InfluxDB")
    private String token;
    @FieldDoc(required=true, defaultValue="", help="The InfluxDB organization to write to")
    private String organization;
    @FieldDoc(required=true, defaultValue="", help="The InfluxDB bucket to write to")
    private String bucket;
    @FieldDoc(required=false, defaultValue="ONE", help="The timestamp precision for writing data to InfluxDB. Possible values [ns, us, ms, s]")
    private String precision = "ns";
    @FieldDoc(required=false, defaultValue="NONE", help="The log level for InfluxDB request and response. Possible values [NONE, BASIC, HEADERS, FULL]")
    private String logLevel = "NONE";
    @FieldDoc(required=false, defaultValue="false", help="Flag to determine if gzip should be enabled")
    private boolean gzipEnable = false;
    @FieldDoc(required=false, defaultValue="1000L", help="The InfluxDB operation time in milliseconds")
    private long batchTimeMs = 1000L;
    @FieldDoc(required=false, defaultValue="200", help="The batch size of write to InfluxDB database")
    private int batchSize = 200;

    public static InfluxDBSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (InfluxDBSinkConfig)mapper.readValue(new File(yamlFile), InfluxDBSinkConfig.class);
    }

    public static InfluxDBSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (InfluxDBSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), InfluxDBSinkConfig.class);
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.influxdbUrl, (Object)"influxdbUrl property not set.");
        Preconditions.checkNotNull((Object)this.token, (Object)"token property not set.");
        Preconditions.checkNotNull((Object)this.organization, (Object)"organization property not set.");
        Preconditions.checkNotNull((Object)this.bucket, (Object)"bucket property not set.");
        Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batchSize must be a positive integer.");
        Preconditions.checkArgument((this.batchTimeMs > 0L ? 1 : 0) != 0, (Object)"batchTimeMs must be a positive long.");
    }

    public String getInfluxdbUrl() {
        return this.influxdbUrl;
    }

    public String getToken() {
        return this.token;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getPrecision() {
        return this.precision;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public boolean isGzipEnable() {
        return this.gzipEnable;
    }

    public long getBatchTimeMs() {
        return this.batchTimeMs;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public InfluxDBSinkConfig setInfluxdbUrl(String influxdbUrl) {
        this.influxdbUrl = influxdbUrl;
        return this;
    }

    public InfluxDBSinkConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public InfluxDBSinkConfig setOrganization(String organization) {
        this.organization = organization;
        return this;
    }

    public InfluxDBSinkConfig setBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public InfluxDBSinkConfig setPrecision(String precision) {
        this.precision = precision;
        return this;
    }

    public InfluxDBSinkConfig setLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    public InfluxDBSinkConfig setGzipEnable(boolean gzipEnable) {
        this.gzipEnable = gzipEnable;
        return this;
    }

    public InfluxDBSinkConfig setBatchTimeMs(long batchTimeMs) {
        this.batchTimeMs = batchTimeMs;
        return this;
    }

    public InfluxDBSinkConfig setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDBSinkConfig)) {
            return false;
        }
        InfluxDBSinkConfig other = (InfluxDBSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGzipEnable() != other.isGzipEnable()) {
            return false;
        }
        if (this.getBatchTimeMs() != other.getBatchTimeMs()) {
            return false;
        }
        if (this.getBatchSize() != other.getBatchSize()) {
            return false;
        }
        String this$influxdbUrl = this.getInfluxdbUrl();
        String other$influxdbUrl = other.getInfluxdbUrl();
        if (this$influxdbUrl == null ? other$influxdbUrl != null : !this$influxdbUrl.equals(other$influxdbUrl)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
            return false;
        }
        String this$organization = this.getOrganization();
        String other$organization = other.getOrganization();
        if (this$organization == null ? other$organization != null : !this$organization.equals(other$organization)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$precision = this.getPrecision();
        String other$precision = other.getPrecision();
        if (this$precision == null ? other$precision != null : !this$precision.equals(other$precision)) {
            return false;
        }
        String this$logLevel = this.getLogLevel();
        String other$logLevel = other.getLogLevel();
        return !(this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDBSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGzipEnable() ? 79 : 97);
        long $batchTimeMs = this.getBatchTimeMs();
        result = result * 59 + (int)($batchTimeMs >>> 32 ^ $batchTimeMs);
        result = result * 59 + this.getBatchSize();
        String $influxdbUrl = this.getInfluxdbUrl();
        result = result * 59 + ($influxdbUrl == null ? 43 : $influxdbUrl.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        String $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : $organization.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        String $precision = this.getPrecision();
        result = result * 59 + ($precision == null ? 43 : $precision.hashCode());
        String $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDBSinkConfig(influxdbUrl=" + this.getInfluxdbUrl() + ", token=" + this.getToken() + ", organization=" + this.getOrganization() + ", bucket=" + this.getBucket() + ", precision=" + this.getPrecision() + ", logLevel=" + this.getLogLevel() + ", gzipEnable=" + this.isGzipEnable() + ", batchTimeMs=" + this.getBatchTimeMs() + ", batchSize=" + this.getBatchSize() + ")";
    }
}

