/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class KafkaSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of host and port pairs that are the addresses of the Kafka brokers that a Kafka client connects to initially bootstrap itself")
    private String bootstrapServers;
    @FieldDoc(required=false, defaultValue="", help="Protocol used to communicate with Kafka brokers.")
    private String securityProtocol;
    @FieldDoc(required=false, defaultValue="", help="SASL mechanism used for Kafka client connections.")
    private String saslMechanism;
    @FieldDoc(required=false, defaultValue="", help="JAAS login context parameters for SASL connections in the format used by JAAS configuration files.")
    private String saslJaasConfig;
    @FieldDoc(required=false, defaultValue="", help="The list of protocols enabled for SSL connections.")
    private String sslEnabledProtocols;
    @FieldDoc(required=false, defaultValue="", help="The endpoint identification algorithm to validate server hostname using server certificate.")
    private String sslEndpointIdentificationAlgorithm;
    @FieldDoc(required=false, defaultValue="", help="The location of the trust store file.")
    private String sslTruststoreLocation;
    @FieldDoc(required=false, defaultValue="", help="The password for the trust store file.")
    private String sslTruststorePassword;
    @FieldDoc(required=true, defaultValue="", help="A string that uniquely identifies the group of consumer processes to which this consumer belongs.")
    private String groupId;
    @FieldDoc(defaultValue="1", help="The minimum amount of data the server should return for a fetch request.")
    private long fetchMinBytes = 1L;
    @FieldDoc(defaultValue="5000", help="The frequency in milliseconds that the consumer offsets are auto-committed to Kafka if autoCommitEnabled is set to true.")
    private long autoCommitIntervalMs = 5000L;
    @FieldDoc(defaultValue="30000", help="The timeout used to detect failures when using Kafka's group management facilities.")
    private long sessionTimeoutMs = 30000L;
    @FieldDoc(defaultValue="3000", help="The interval between heartbeats to the consumer when using Kafka's group management facilities. The value must be lower than session timeout.")
    private long heartbeatIntervalMs = 3000L;
    @FieldDoc(defaultValue="true", help="If true the consumer's offset will be periodically committed in the background.")
    private boolean autoCommitEnabled = true;
    @FieldDoc(required=true, defaultValue="", help="The Kafka topic that is used for Pulsar moving messages to.")
    private String topic;
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.StringDeserializer", help="The deserializer class for Kafka consumer to deserialize keys.")
    private String keyDeserializationClass = "org.apache.kafka.common.serialization.StringDeserializer";
    @FieldDoc(defaultValue="org.apache.kafka.common.serialization.ByteArrayDeserializer", help="The deserializer class for Kafka consumer to deserialize values. You typically shouldn't care this. Since the deserializer will be set by a specific implementation of `KafkaAbstractSource`.")
    private String valueDeserializationClass = "org.apache.kafka.common.serialization.ByteArrayDeserializer";
    @FieldDoc(defaultValue="earliest", help="The default offset reset policy.")
    private String autoOffsetReset = "earliest";
    @FieldDoc(defaultValue="", help="The consumer config properties to be passed to Consumer. Note that other properties specified in the connector config file take precedence over this config.")
    private Map<String, Object> consumerConfigProperties;

    public static KafkaSourceConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (KafkaSourceConfig)mapper.readValue(new File(yamlFile), KafkaSourceConfig.class);
    }

    public static KafkaSourceConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (KafkaSourceConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), KafkaSourceConfig.class);
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getSaslMechanism() {
        return this.saslMechanism;
    }

    public String getSaslJaasConfig() {
        return this.saslJaasConfig;
    }

    public String getSslEnabledProtocols() {
        return this.sslEnabledProtocols;
    }

    public String getSslEndpointIdentificationAlgorithm() {
        return this.sslEndpointIdentificationAlgorithm;
    }

    public String getSslTruststoreLocation() {
        return this.sslTruststoreLocation;
    }

    public String getSslTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public long getFetchMinBytes() {
        return this.fetchMinBytes;
    }

    public long getAutoCommitIntervalMs() {
        return this.autoCommitIntervalMs;
    }

    public long getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public long getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getKeyDeserializationClass() {
        return this.keyDeserializationClass;
    }

    public String getValueDeserializationClass() {
        return this.valueDeserializationClass;
    }

    public String getAutoOffsetReset() {
        return this.autoOffsetReset;
    }

    public Map<String, Object> getConsumerConfigProperties() {
        return this.consumerConfigProperties;
    }

    public KafkaSourceConfig setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public KafkaSourceConfig setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
        return this;
    }

    public KafkaSourceConfig setSaslMechanism(String saslMechanism) {
        this.saslMechanism = saslMechanism;
        return this;
    }

    public KafkaSourceConfig setSaslJaasConfig(String saslJaasConfig) {
        this.saslJaasConfig = saslJaasConfig;
        return this;
    }

    public KafkaSourceConfig setSslEnabledProtocols(String sslEnabledProtocols) {
        this.sslEnabledProtocols = sslEnabledProtocols;
        return this;
    }

    public KafkaSourceConfig setSslEndpointIdentificationAlgorithm(String sslEndpointIdentificationAlgorithm) {
        this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
        return this;
    }

    public KafkaSourceConfig setSslTruststoreLocation(String sslTruststoreLocation) {
        this.sslTruststoreLocation = sslTruststoreLocation;
        return this;
    }

    public KafkaSourceConfig setSslTruststorePassword(String sslTruststorePassword) {
        this.sslTruststorePassword = sslTruststorePassword;
        return this;
    }

    public KafkaSourceConfig setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public KafkaSourceConfig setFetchMinBytes(long fetchMinBytes) {
        this.fetchMinBytes = fetchMinBytes;
        return this;
    }

    public KafkaSourceConfig setAutoCommitIntervalMs(long autoCommitIntervalMs) {
        this.autoCommitIntervalMs = autoCommitIntervalMs;
        return this;
    }

    public KafkaSourceConfig setSessionTimeoutMs(long sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
        return this;
    }

    public KafkaSourceConfig setHeartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        return this;
    }

    public KafkaSourceConfig setAutoCommitEnabled(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
        return this;
    }

    public KafkaSourceConfig setTopic(String topic) {
        this.topic = topic;
        return this;
    }

    public KafkaSourceConfig setKeyDeserializationClass(String keyDeserializationClass) {
        this.keyDeserializationClass = keyDeserializationClass;
        return this;
    }

    public KafkaSourceConfig setValueDeserializationClass(String valueDeserializationClass) {
        this.valueDeserializationClass = valueDeserializationClass;
        return this;
    }

    public KafkaSourceConfig setAutoOffsetReset(String autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
        return this;
    }

    public KafkaSourceConfig setConsumerConfigProperties(Map<String, Object> consumerConfigProperties) {
        this.consumerConfigProperties = consumerConfigProperties;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaSourceConfig)) {
            return false;
        }
        KafkaSourceConfig other = (KafkaSourceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFetchMinBytes() != other.getFetchMinBytes()) {
            return false;
        }
        if (this.getAutoCommitIntervalMs() != other.getAutoCommitIntervalMs()) {
            return false;
        }
        if (this.getSessionTimeoutMs() != other.getSessionTimeoutMs()) {
            return false;
        }
        if (this.getHeartbeatIntervalMs() != other.getHeartbeatIntervalMs()) {
            return false;
        }
        if (this.isAutoCommitEnabled() != other.isAutoCommitEnabled()) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        String this$securityProtocol = this.getSecurityProtocol();
        String other$securityProtocol = other.getSecurityProtocol();
        if (this$securityProtocol == null ? other$securityProtocol != null : !this$securityProtocol.equals(other$securityProtocol)) {
            return false;
        }
        String this$saslMechanism = this.getSaslMechanism();
        String other$saslMechanism = other.getSaslMechanism();
        if (this$saslMechanism == null ? other$saslMechanism != null : !this$saslMechanism.equals(other$saslMechanism)) {
            return false;
        }
        String this$saslJaasConfig = this.getSaslJaasConfig();
        String other$saslJaasConfig = other.getSaslJaasConfig();
        if (this$saslJaasConfig == null ? other$saslJaasConfig != null : !this$saslJaasConfig.equals(other$saslJaasConfig)) {
            return false;
        }
        String this$sslEnabledProtocols = this.getSslEnabledProtocols();
        String other$sslEnabledProtocols = other.getSslEnabledProtocols();
        if (this$sslEnabledProtocols == null ? other$sslEnabledProtocols != null : !this$sslEnabledProtocols.equals(other$sslEnabledProtocols)) {
            return false;
        }
        String this$sslEndpointIdentificationAlgorithm = this.getSslEndpointIdentificationAlgorithm();
        String other$sslEndpointIdentificationAlgorithm = other.getSslEndpointIdentificationAlgorithm();
        if (this$sslEndpointIdentificationAlgorithm == null ? other$sslEndpointIdentificationAlgorithm != null : !this$sslEndpointIdentificationAlgorithm.equals(other$sslEndpointIdentificationAlgorithm)) {
            return false;
        }
        String this$sslTruststoreLocation = this.getSslTruststoreLocation();
        String other$sslTruststoreLocation = other.getSslTruststoreLocation();
        if (this$sslTruststoreLocation == null ? other$sslTruststoreLocation != null : !this$sslTruststoreLocation.equals(other$sslTruststoreLocation)) {
            return false;
        }
        String this$sslTruststorePassword = this.getSslTruststorePassword();
        String other$sslTruststorePassword = other.getSslTruststorePassword();
        if (this$sslTruststorePassword == null ? other$sslTruststorePassword != null : !this$sslTruststorePassword.equals(other$sslTruststorePassword)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$keyDeserializationClass = this.getKeyDeserializationClass();
        String other$keyDeserializationClass = other.getKeyDeserializationClass();
        if (this$keyDeserializationClass == null ? other$keyDeserializationClass != null : !this$keyDeserializationClass.equals(other$keyDeserializationClass)) {
            return false;
        }
        String this$valueDeserializationClass = this.getValueDeserializationClass();
        String other$valueDeserializationClass = other.getValueDeserializationClass();
        if (this$valueDeserializationClass == null ? other$valueDeserializationClass != null : !this$valueDeserializationClass.equals(other$valueDeserializationClass)) {
            return false;
        }
        String this$autoOffsetReset = this.getAutoOffsetReset();
        String other$autoOffsetReset = other.getAutoOffsetReset();
        if (this$autoOffsetReset == null ? other$autoOffsetReset != null : !this$autoOffsetReset.equals(other$autoOffsetReset)) {
            return false;
        }
        Map<String, Object> this$consumerConfigProperties = this.getConsumerConfigProperties();
        Map<String, Object> other$consumerConfigProperties = other.getConsumerConfigProperties();
        return !(this$consumerConfigProperties == null ? other$consumerConfigProperties != null : !((Object)this$consumerConfigProperties).equals(other$consumerConfigProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaSourceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $fetchMinBytes = this.getFetchMinBytes();
        result = result * 59 + (int)($fetchMinBytes >>> 32 ^ $fetchMinBytes);
        long $autoCommitIntervalMs = this.getAutoCommitIntervalMs();
        result = result * 59 + (int)($autoCommitIntervalMs >>> 32 ^ $autoCommitIntervalMs);
        long $sessionTimeoutMs = this.getSessionTimeoutMs();
        result = result * 59 + (int)($sessionTimeoutMs >>> 32 ^ $sessionTimeoutMs);
        long $heartbeatIntervalMs = this.getHeartbeatIntervalMs();
        result = result * 59 + (int)($heartbeatIntervalMs >>> 32 ^ $heartbeatIntervalMs);
        result = result * 59 + (this.isAutoCommitEnabled() ? 79 : 97);
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        String $securityProtocol = this.getSecurityProtocol();
        result = result * 59 + ($securityProtocol == null ? 43 : $securityProtocol.hashCode());
        String $saslMechanism = this.getSaslMechanism();
        result = result * 59 + ($saslMechanism == null ? 43 : $saslMechanism.hashCode());
        String $saslJaasConfig = this.getSaslJaasConfig();
        result = result * 59 + ($saslJaasConfig == null ? 43 : $saslJaasConfig.hashCode());
        String $sslEnabledProtocols = this.getSslEnabledProtocols();
        result = result * 59 + ($sslEnabledProtocols == null ? 43 : $sslEnabledProtocols.hashCode());
        String $sslEndpointIdentificationAlgorithm = this.getSslEndpointIdentificationAlgorithm();
        result = result * 59 + ($sslEndpointIdentificationAlgorithm == null ? 43 : $sslEndpointIdentificationAlgorithm.hashCode());
        String $sslTruststoreLocation = this.getSslTruststoreLocation();
        result = result * 59 + ($sslTruststoreLocation == null ? 43 : $sslTruststoreLocation.hashCode());
        String $sslTruststorePassword = this.getSslTruststorePassword();
        result = result * 59 + ($sslTruststorePassword == null ? 43 : $sslTruststorePassword.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $keyDeserializationClass = this.getKeyDeserializationClass();
        result = result * 59 + ($keyDeserializationClass == null ? 43 : $keyDeserializationClass.hashCode());
        String $valueDeserializationClass = this.getValueDeserializationClass();
        result = result * 59 + ($valueDeserializationClass == null ? 43 : $valueDeserializationClass.hashCode());
        String $autoOffsetReset = this.getAutoOffsetReset();
        result = result * 59 + ($autoOffsetReset == null ? 43 : $autoOffsetReset.hashCode());
        Map<String, Object> $consumerConfigProperties = this.getConsumerConfigProperties();
        result = result * 59 + ($consumerConfigProperties == null ? 43 : ((Object)$consumerConfigProperties).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaSourceConfig(bootstrapServers=" + this.getBootstrapServers() + ", securityProtocol=" + this.getSecurityProtocol() + ", saslMechanism=" + this.getSaslMechanism() + ", saslJaasConfig=" + this.getSaslJaasConfig() + ", sslEnabledProtocols=" + this.getSslEnabledProtocols() + ", sslEndpointIdentificationAlgorithm=" + this.getSslEndpointIdentificationAlgorithm() + ", sslTruststoreLocation=" + this.getSslTruststoreLocation() + ", sslTruststorePassword=" + this.getSslTruststorePassword() + ", groupId=" + this.getGroupId() + ", fetchMinBytes=" + this.getFetchMinBytes() + ", autoCommitIntervalMs=" + this.getAutoCommitIntervalMs() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", heartbeatIntervalMs=" + this.getHeartbeatIntervalMs() + ", autoCommitEnabled=" + this.isAutoCommitEnabled() + ", topic=" + this.getTopic() + ", keyDeserializationClass=" + this.getKeyDeserializationClass() + ", valueDeserializationClass=" + this.getValueDeserializationClass() + ", autoOffsetReset=" + this.getAutoOffsetReset() + ", consumerConfigProperties=" + this.getConsumerConfigProperties() + ")";
    }
}

