/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.kafka;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import org.apache.avro.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.io.kafka.ByteBufferSchemaWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AvroSchemaCache {
    private static final Logger log = LoggerFactory.getLogger(AvroSchemaCache.class);
    private final LoadingCache<Integer, org.apache.pulsar.client.api.Schema<ByteBuffer>> cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<Integer, org.apache.pulsar.client.api.Schema<ByteBuffer>>(){

        public org.apache.pulsar.client.api.Schema<ByteBuffer> load(Integer schemaId) throws Exception {
            return AvroSchemaCache.this.fetchSchema(schemaId);
        }
    });
    private final SchemaRegistryClient schemaRegistryClient;

    public AvroSchemaCache(SchemaRegistryClient schemaRegistryClient) {
        this.schemaRegistryClient = schemaRegistryClient;
    }

    public org.apache.pulsar.client.api.Schema<ByteBuffer> get(int schemaId) {
        try {
            return (org.apache.pulsar.client.api.Schema)this.cache.get((Object)schemaId);
        }
        catch (ExecutionException err) {
            throw new RuntimeException(err.getCause());
        }
    }

    private org.apache.pulsar.client.api.Schema<ByteBuffer> fetchSchema(int schemaId) {
        try {
            Schema schema = this.schemaRegistryClient.getById(schemaId);
            String definition = schema.toString(false);
            log.info("Schema {} definition {}", (Object)schemaId, (Object)definition);
            SchemaInfo schemaInfo = SchemaInfo.builder().type(SchemaType.AVRO).name(schema.getName()).properties(Collections.emptyMap()).schema(definition.getBytes(StandardCharsets.UTF_8)).build();
            return new ByteBufferSchemaWrapper(schemaInfo);
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e);
        }
    }
}

