/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.solr;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class SolrSinkConfig
implements Serializable {
    private static final long serialVersionUID = -4849066206354610110L;
    @FieldDoc(required=true, defaultValue="", help="Comma separated zookeeper hosts with chroot used in SolrCloud mode (eg: localhost:2181,localhost:2182/chroot) or Url to connect to solr used in Standalone mode (e.g. localhost:8983/solr)")
    private String solrUrl;
    @FieldDoc(required=true, defaultValue="SolrCloud", help="The client mode to use when interacting with the Solr cluster. Possible values [Standalone, SolrCloud]")
    private String solrMode = "SolrCloud";
    @FieldDoc(required=true, defaultValue="", help="Solr collection name to which records need to be written")
    private String solrCollection;
    @FieldDoc(required=false, defaultValue="10", help="Commit within milli seconds for solr update, if none passes defaults to 10 ms")
    private int solrCommitWithinMs = 10;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The username to use for basic authentication")
    private String username;
    @FieldDoc(required=false, defaultValue="", sensitive=true, help="The password to use for basic authentication")
    private String password;

    public static SolrSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (SolrSinkConfig)mapper.readValue(new File(yamlFile), SolrSinkConfig.class);
    }

    public static SolrSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (SolrSinkConfig)mapper.readValue(new ObjectMapper().writeValueAsString(map), SolrSinkConfig.class);
    }

    public void validate() {
        Preconditions.checkNotNull((Object)this.solrUrl, (Object)"solrUrl property not set.");
        Preconditions.checkNotNull((Object)this.solrMode, (Object)"solrMode property not set.");
        Preconditions.checkNotNull((Object)this.solrCollection, (Object)"solrCollection property not set.");
        Preconditions.checkArgument((this.solrCommitWithinMs > 0 ? 1 : 0) != 0, (Object)"solrCommitWithinMs must be a positive integer.");
    }

    public String getSolrUrl() {
        return this.solrUrl;
    }

    public String getSolrMode() {
        return this.solrMode;
    }

    public String getSolrCollection() {
        return this.solrCollection;
    }

    public int getSolrCommitWithinMs() {
        return this.solrCommitWithinMs;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SolrSinkConfig setSolrUrl(String solrUrl) {
        this.solrUrl = solrUrl;
        return this;
    }

    public SolrSinkConfig setSolrMode(String solrMode) {
        this.solrMode = solrMode;
        return this;
    }

    public SolrSinkConfig setSolrCollection(String solrCollection) {
        this.solrCollection = solrCollection;
        return this;
    }

    public SolrSinkConfig setSolrCommitWithinMs(int solrCommitWithinMs) {
        this.solrCommitWithinMs = solrCommitWithinMs;
        return this;
    }

    public SolrSinkConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public SolrSinkConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SolrSinkConfig)) {
            return false;
        }
        SolrSinkConfig other = (SolrSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSolrCommitWithinMs() != other.getSolrCommitWithinMs()) {
            return false;
        }
        String this$solrUrl = this.getSolrUrl();
        String other$solrUrl = other.getSolrUrl();
        if (this$solrUrl == null ? other$solrUrl != null : !this$solrUrl.equals(other$solrUrl)) {
            return false;
        }
        String this$solrMode = this.getSolrMode();
        String other$solrMode = other.getSolrMode();
        if (this$solrMode == null ? other$solrMode != null : !this$solrMode.equals(other$solrMode)) {
            return false;
        }
        String this$solrCollection = this.getSolrCollection();
        String other$solrCollection = other.getSolrCollection();
        if (this$solrCollection == null ? other$solrCollection != null : !this$solrCollection.equals(other$solrCollection)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SolrSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSolrCommitWithinMs();
        String $solrUrl = this.getSolrUrl();
        result = result * 59 + ($solrUrl == null ? 43 : $solrUrl.hashCode());
        String $solrMode = this.getSolrMode();
        result = result * 59 + ($solrMode == null ? 43 : $solrMode.hashCode());
        String $solrCollection = this.getSolrCollection();
        result = result * 59 + ($solrCollection == null ? 43 : $solrCollection.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    public String toString() {
        return "SolrSinkConfig(solrUrl=" + this.getSolrUrl() + ", solrMode=" + this.getSolrMode() + ", solrCollection=" + this.getSolrCollection() + ", solrCommitWithinMs=" + this.getSolrCommitWithinMs() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ")";
    }
}

