/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.metadata.bookkeeper;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.AbstractConfiguration;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.LayoutManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.pulsar.metadata.api.extended.SessionEvent;
import org.apache.pulsar.metadata.bookkeeper.AbstractMetadataDriver;

public class PulsarMetadataClientDriver
extends AbstractMetadataDriver
implements MetadataClientDriver {
    public MetadataClientDriver initialize(ClientConfiguration clientConfiguration, ScheduledExecutorService scheduledExecutorService, StatsLogger statsLogger, Optional<Object> optionalCtx) throws MetadataException {
        super.initialize((AbstractConfiguration)clientConfiguration);
        return this;
    }

    public RegistrationClient getRegistrationClient() {
        return this.registrationClient;
    }

    public LedgerManagerFactory getLedgerManagerFactory() throws MetadataException {
        return this.ledgerManagerFactory;
    }

    public LayoutManager getLayoutManager() {
        return this.layoutManager;
    }

    public void setSessionStateListener(MetadataClientDriver.SessionStateListener sessionStateListener) {
        this.store.registerSessionListener(event -> {
            if (event == SessionEvent.SessionLost) {
                sessionStateListener.onSessionExpired();
            }
        });
    }

    static {
        MetadataDrivers.registerClientDriver((String)"metadata-store", PulsarMetadataClientDriver.class);
    }
}

