/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import java.util.Properties;

public class ConsumerConfiguration {
    private String bootstrapServers;
    private String groupId;
    private Object keyDeserializer;
    private Object valueDeserializer;
    private boolean fromEarliest;
    private String securityProtocol;
    private String saslMechanism;
    private String userName;
    private String password;
    private String requestTimeoutMs;
    private Boolean enableAutoCommit;
    private String sessionTimeOutMs;

    public Properties toProperties() {
        Properties props = new Properties();
        if (this.bootstrapServers != null) {
            props.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.groupId != null) {
            props.put("group.id", this.groupId);
        }
        if (this.keyDeserializer != null) {
            props.put("key.deserializer", this.keyDeserializer);
        }
        if (this.valueDeserializer != null) {
            props.put("value.deserializer", this.valueDeserializer);
        }
        props.put("auto.offset.reset", this.fromEarliest ? "earliest" : "latest");
        if (this.securityProtocol != null) {
            props.put("security.protocol", this.securityProtocol);
        }
        if (this.saslMechanism != null) {
            props.put("sasl.mechanism", this.saslMechanism);
        }
        if (this.userName != null && this.password != null) {
            String kafkaAuth = String.format("username=\"%s\" password=\"%s\";", this.userName, this.password);
            props.put("sasl.jaas.config", "org.apache.kafka010.common.security.plain.PlainLoginModule required " + kafkaAuth);
        }
        if (this.requestTimeoutMs != null) {
            props.put("request.timeout.ms", this.requestTimeoutMs);
        }
        if (this.enableAutoCommit != null) {
            props.put("enable.auto.commit", this.enableAutoCommit);
        }
        if (this.sessionTimeOutMs != null) {
            props.put("session.timeout.ms", this.sessionTimeOutMs);
        }
        return props;
    }

    private static boolean $default$fromEarliest() {
        return true;
    }

    ConsumerConfiguration(String bootstrapServers, String groupId, Object keyDeserializer, Object valueDeserializer, boolean fromEarliest, String securityProtocol, String saslMechanism, String userName, String password, String requestTimeoutMs, Boolean enableAutoCommit, String sessionTimeOutMs) {
        this.bootstrapServers = bootstrapServers;
        this.groupId = groupId;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.fromEarliest = fromEarliest;
        this.securityProtocol = securityProtocol;
        this.saslMechanism = saslMechanism;
        this.userName = userName;
        this.password = password;
        this.requestTimeoutMs = requestTimeoutMs;
        this.enableAutoCommit = enableAutoCommit;
        this.sessionTimeOutMs = sessionTimeOutMs;
    }

    public static ConsumerConfigurationBuilder builder() {
        return new ConsumerConfigurationBuilder();
    }

    public static class ConsumerConfigurationBuilder {
        private String bootstrapServers;
        private String groupId;
        private Object keyDeserializer;
        private Object valueDeserializer;
        private boolean fromEarliest$set;
        private boolean fromEarliest$value;
        private String securityProtocol;
        private String saslMechanism;
        private String userName;
        private String password;
        private String requestTimeoutMs;
        private Boolean enableAutoCommit;
        private String sessionTimeOutMs;

        ConsumerConfigurationBuilder() {
        }

        public ConsumerConfigurationBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public ConsumerConfigurationBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public ConsumerConfigurationBuilder keyDeserializer(Object keyDeserializer) {
            this.keyDeserializer = keyDeserializer;
            return this;
        }

        public ConsumerConfigurationBuilder valueDeserializer(Object valueDeserializer) {
            this.valueDeserializer = valueDeserializer;
            return this;
        }

        public ConsumerConfigurationBuilder fromEarliest(boolean fromEarliest) {
            this.fromEarliest$value = fromEarliest;
            this.fromEarliest$set = true;
            return this;
        }

        public ConsumerConfigurationBuilder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        public ConsumerConfigurationBuilder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            return this;
        }

        public ConsumerConfigurationBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public ConsumerConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ConsumerConfigurationBuilder requestTimeoutMs(String requestTimeoutMs) {
            this.requestTimeoutMs = requestTimeoutMs;
            return this;
        }

        public ConsumerConfigurationBuilder enableAutoCommit(Boolean enableAutoCommit) {
            this.enableAutoCommit = enableAutoCommit;
            return this;
        }

        public ConsumerConfigurationBuilder sessionTimeOutMs(String sessionTimeOutMs) {
            this.sessionTimeOutMs = sessionTimeOutMs;
            return this;
        }

        public ConsumerConfiguration build() {
            boolean fromEarliest$value = this.fromEarliest$value;
            if (!this.fromEarliest$set) {
                fromEarliest$value = ConsumerConfiguration.$default$fromEarliest();
            }
            return new ConsumerConfiguration(this.bootstrapServers, this.groupId, this.keyDeserializer, this.valueDeserializer, fromEarliest$value, this.securityProtocol, this.saslMechanism, this.userName, this.password, this.requestTimeoutMs, this.enableAutoCommit, this.sessionTimeOutMs);
        }

        public String toString() {
            return "ConsumerConfiguration.ConsumerConfigurationBuilder(bootstrapServers=" + this.bootstrapServers + ", groupId=" + this.groupId + ", keyDeserializer=" + this.keyDeserializer + ", valueDeserializer=" + this.valueDeserializer + ", fromEarliest$value=" + this.fromEarliest$value + ", securityProtocol=" + this.securityProtocol + ", saslMechanism=" + this.saslMechanism + ", userName=" + this.userName + ", password=" + this.password + ", requestTimeoutMs=" + this.requestTimeoutMs + ", enableAutoCommit=" + this.enableAutoCommit + ", sessionTimeOutMs=" + this.sessionTimeOutMs + ")";
        }
    }
}

