/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.Header;
import io.streamnative.kafka.client.api.Producer;
import io.streamnative.kafka.client.api.RecordMetadata;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.BiFunction;

public class ProduceContext<K, V> {
    private final Producer<K, V> producer;
    private final String topic;
    private final Integer partition;
    private final Long timestamp;
    private final K key;
    private final V value;
    private final List<Header> headers;
    private final CompletableFuture<RecordMetadata> future = new CompletableFuture();

    public <T, HeaderT> T createV2ProducerRecord(Class<T> clazz, BiFunction<String, byte[], HeaderT> headerConstructor) {
        try {
            return clazz.getConstructor(String.class, Integer.class, Long.class, Object.class, Object.class, Iterable.class).newInstance(this.topic, this.partition, this.timestamp, this.key, this.value, Header.toHeaders(this.headers, headerConstructor));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T createV1ProducerRecord(Class<T> clazz) {
        try {
            return clazz.getConstructor(String.class, Integer.class, Long.class, Object.class, Object.class).newInstance(this.topic, this.partition, this.timestamp, this.key, this.value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T createV0ProducerRecord(Class<T> clazz) {
        try {
            return clazz.getConstructor(String.class, Integer.class, Object.class, Object.class).newInstance(this.topic, this.partition, this.key, this.value);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> void complete(T metadata, Exception e) {
        if (e == null) {
            this.future.complete(RecordMetadata.create(metadata));
        } else {
            this.future.completeExceptionally(e);
        }
    }

    public Future<RecordMetadata> sendAsync() {
        if (this.producer == null) {
            throw new IllegalArgumentException("producer is null");
        }
        return this.producer.sendAsync(this);
    }

    public static <K, V> ProduceContextBuilder<K, V> builder() {
        return new ProduceContextBuilder();
    }

    public Producer<K, V> getProducer() {
        return this.producer;
    }

    public String getTopic() {
        return this.topic;
    }

    public Integer getPartition() {
        return this.partition;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public CompletableFuture<RecordMetadata> getFuture() {
        return this.future;
    }

    public ProduceContext(Producer<K, V> producer, String topic, Integer partition, Long timestamp, K key, V value, List<Header> headers) {
        this.producer = producer;
        this.topic = topic;
        this.partition = partition;
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
        this.headers = headers;
    }

    public static class ProduceContextBuilder<K, V> {
        private Producer<K, V> producer;
        private String topic;
        private Integer partition;
        private Long timestamp;
        private K key;
        private V value;
        private List<Header> headers;

        public ProduceContext<K, V> build() {
            return new ProduceContext<K, V>(this.producer, this.topic, this.partition, this.timestamp, this.key, this.value, this.headers);
        }

        public ProduceContextBuilder<K, V> producer(Producer<K, V> producer) {
            this.producer = producer;
            return this;
        }

        public ProduceContextBuilder<K, V> topic(String topic) {
            this.topic = topic;
            return this;
        }

        public ProduceContextBuilder<K, V> partition(Integer partition) {
            this.partition = partition;
            return this;
        }

        public ProduceContextBuilder<K, V> timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ProduceContextBuilder<K, V> key(K key) {
            this.key = key;
            return this;
        }

        public ProduceContextBuilder<K, V> value(V value) {
            this.value = value;
            return this;
        }

        public ProduceContextBuilder<K, V> headers(List<Header> headers) {
            this.headers = headers;
            return this;
        }
    }
}

