/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.zero.ten;

import io.streamnative.kafka.client.api.Consumer;
import io.streamnative.kafka.client.api.ConsumerConfiguration;
import io.streamnative.kafka.client.api.ConsumerRecord;
import io.streamnative.kafka.client.api.TopicOffsetAndMetadata;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka010.clients.consumer.KafkaConsumer;
import org.apache.kafka010.clients.consumer.OffsetAndMetadata;
import org.apache.kafka010.common.PartitionInfo;
import org.apache.kafka010.common.TopicPartition;

public class Consumer010Impl<K, V>
extends KafkaConsumer<K, V>
implements Consumer<K, V> {
    public Consumer010Impl(ConsumerConfiguration conf) {
        super(conf.toProperties());
    }

    @Override
    public List<ConsumerRecord<K, V>> receive(long timeoutMs) {
        ArrayList records = new ArrayList();
        this.poll(timeoutMs).forEach(record -> records.add(ConsumerRecord.createOldRecord(record)));
        return records;
    }

    @Override
    public Map<String, List<PartitionInfo>> listTopics(long timeoutMS) {
        return this.listTopics();
    }

    @Override
    public void commitOffsetSync(List<TopicOffsetAndMetadata> offsets, Duration timeout) {
        HashMap<TopicPartition, OffsetAndMetadata> offsetsMap = new HashMap<TopicPartition, OffsetAndMetadata>();
        offsets.forEach(offsetAndMetadata -> offsetsMap.put(offsetAndMetadata.createTopicPartition(TopicPartition.class), offsetAndMetadata.createOffsetAndMetadata(OffsetAndMetadata.class)));
        this.commitSync(offsetsMap);
    }
}

