/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common;

public class Node {
    private static final Node NO_NODE = new Node(-1, "", -1);
    private final int id;
    private final String idString;
    private final String host;
    private final int port;
    private final String rack;

    public Node(int id, String host, int port) {
        this(id, host, port, null);
    }

    public Node(int id, String host, int port, String rack) {
        this.id = id;
        this.idString = Integer.toString(id);
        this.host = host;
        this.port = port;
        this.rack = rack;
    }

    public static Node noNode() {
        return NO_NODE;
    }

    public boolean isEmpty() {
        return this.host == null || this.host.isEmpty() || this.port < 0;
    }

    public int id() {
        return this.id;
    }

    public String idString() {
        return this.idString;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public boolean hasRack() {
        return this.rack != null;
    }

    public String rack() {
        return this.rack;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + this.id;
        result = 31 * result + this.port;
        result = 31 * result + (this.rack == null ? 0 : this.rack.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Node other = (Node)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        return !(this.rack == null ? other.rack != null : !this.rack.equals(other.rack));
    }

    public String toString() {
        return this.host + ":" + this.port + " (id: " + this.idString + " rack: " + this.rack + ")";
    }
}

