/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.kafka010.common.errors.CorruptRecordException;
import org.apache.kafka010.common.record.LogEntry;
import org.apache.kafka010.common.record.LogInputStream;
import org.apache.kafka010.common.record.Record;
import org.apache.kafka010.common.record.TimestampType;
import org.apache.kafka010.common.utils.Utils;

class ByteBufferLogInputStream
implements LogInputStream<ByteBufferLogEntry> {
    private final ByteBuffer buffer;
    private final int maxMessageSize;

    ByteBufferLogInputStream(ByteBuffer buffer, int maxMessageSize) {
        this.buffer = buffer;
        this.maxMessageSize = maxMessageSize;
    }

    @Override
    public ByteBufferLogEntry nextEntry() throws IOException {
        int remaining = this.buffer.remaining();
        if (remaining < 12) {
            return null;
        }
        int recordSize = this.buffer.getInt(this.buffer.position() + 8);
        if (recordSize < 14) {
            throw new CorruptRecordException(String.format("Record size is less than the minimum record overhead (%d)", 14));
        }
        if (recordSize > this.maxMessageSize) {
            throw new CorruptRecordException(String.format("Record size exceeds the largest allowable message size (%d).", this.maxMessageSize));
        }
        int entrySize = recordSize + 12;
        if (remaining < entrySize) {
            return null;
        }
        ByteBuffer entrySlice = this.buffer.slice();
        entrySlice.limit(entrySize);
        this.buffer.position(this.buffer.position() + entrySize);
        return new ByteBufferLogEntry(entrySlice);
    }

    public static class ByteBufferLogEntry
    extends LogEntry {
        private final ByteBuffer buffer;
        private final Record record;

        private ByteBufferLogEntry(ByteBuffer buffer) {
            this.buffer = buffer;
            buffer.position(12);
            this.record = new Record(buffer.slice());
            buffer.position(0);
        }

        @Override
        public long offset() {
            return this.buffer.getLong(0);
        }

        @Override
        public Record record() {
            return this.record;
        }

        public void setOffset(long offset) {
            this.buffer.putLong(0, offset);
        }

        public void setCreateTime(long timestamp) {
            if (this.record.magic() == 0) {
                throw new IllegalArgumentException("Cannot set timestamp for a record with magic = 0");
            }
            long currentTimestamp = this.record.timestamp();
            if (this.record.timestampType() == TimestampType.CREATE_TIME && currentTimestamp == timestamp) {
                return;
            }
            this.setTimestampAndUpdateCrc(TimestampType.CREATE_TIME, timestamp);
        }

        public void setLogAppendTime(long timestamp) {
            if (this.record.magic() == 0) {
                throw new IllegalArgumentException("Cannot set timestamp for a record with magic = 0");
            }
            this.setTimestampAndUpdateCrc(TimestampType.LOG_APPEND_TIME, timestamp);
        }

        private void setTimestampAndUpdateCrc(TimestampType timestampType, long timestamp) {
            byte attributes = this.record.attributes();
            this.buffer.put(17, timestampType.updateAttributes(attributes));
            this.buffer.putLong(18, timestamp);
            long crc = this.record.computeChecksum();
            Utils.writeUnsignedInt(this.buffer, 12, crc);
        }

        public ByteBuffer buffer() {
            return this.buffer;
        }
    }
}

