/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.kafka010.common.KafkaException;
import org.apache.kafka010.common.errors.CorruptRecordException;
import org.apache.kafka010.common.record.LogEntry;
import org.apache.kafka010.common.record.LogInputStream;
import org.apache.kafka010.common.record.Record;
import org.apache.kafka010.common.utils.Utils;

public class FileLogInputStream
implements LogInputStream<FileChannelLogEntry> {
    private int position;
    private final int end;
    private final FileChannel channel;
    private final int maxRecordSize;
    private final ByteBuffer logHeaderBuffer = ByteBuffer.allocate(12);

    public FileLogInputStream(FileChannel channel, int maxRecordSize, int start, int end) {
        this.channel = channel;
        this.maxRecordSize = maxRecordSize;
        this.position = start;
        this.end = end;
    }

    @Override
    public FileChannelLogEntry nextEntry() throws IOException {
        if (this.position + 12 >= this.end) {
            return null;
        }
        this.logHeaderBuffer.rewind();
        Utils.readFullyOrFail(this.channel, this.logHeaderBuffer, this.position, "log header");
        this.logHeaderBuffer.rewind();
        long offset = this.logHeaderBuffer.getLong();
        int size = this.logHeaderBuffer.getInt();
        if (size < 14) {
            throw new CorruptRecordException(String.format("Record size is smaller than minimum record overhead (%d).", 14));
        }
        if (size > this.maxRecordSize) {
            throw new CorruptRecordException(String.format("Record size exceeds the largest allowable message size (%d).", this.maxRecordSize));
        }
        if (this.position + 12 + size > this.end) {
            return null;
        }
        FileChannelLogEntry logEntry = new FileChannelLogEntry(offset, this.channel, this.position, size);
        this.position += logEntry.sizeInBytes();
        return logEntry;
    }

    public static class FileChannelLogEntry
    extends LogEntry {
        private final long offset;
        private final FileChannel channel;
        private final int position;
        private final int recordSize;
        private Record record = null;

        private FileChannelLogEntry(long offset, FileChannel channel, int position, int recordSize) {
            this.offset = offset;
            this.channel = channel;
            this.position = position;
            this.recordSize = recordSize;
        }

        @Override
        public long offset() {
            return this.offset;
        }

        public int position() {
            return this.position;
        }

        @Override
        public byte magic() {
            if (this.record != null) {
                return this.record.magic();
            }
            try {
                byte[] magic = new byte[1];
                ByteBuffer buf = ByteBuffer.wrap(magic);
                Utils.readFullyOrFail(this.channel, buf, this.position + 12 + 4, "magic byte");
                return magic[0];
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
        }

        private Record loadRecord() throws IOException {
            if (this.record != null) {
                return this.record;
            }
            ByteBuffer recordBuffer = ByteBuffer.allocate(this.recordSize);
            Utils.readFullyOrFail(this.channel, recordBuffer, this.position + 12, "full record");
            recordBuffer.rewind();
            this.record = new Record(recordBuffer);
            return this.record;
        }

        @Override
        public Record record() {
            if (this.record != null) {
                return this.record;
            }
            try {
                return this.loadRecord();
            }
            catch (IOException e) {
                throw new KafkaException(e);
            }
        }

        @Override
        public int sizeInBytes() {
            return 12 + this.recordSize;
        }
    }
}

