/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import org.apache.kafka010.common.network.NetworkSend;
import org.apache.kafka010.common.network.Send;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractRequestResponse;
import org.apache.kafka010.common.requests.ApiVersionsResponse;
import org.apache.kafka010.common.requests.ControlledShutdownResponse;
import org.apache.kafka010.common.requests.CreateTopicsResponse;
import org.apache.kafka010.common.requests.DeleteTopicsResponse;
import org.apache.kafka010.common.requests.DescribeGroupsResponse;
import org.apache.kafka010.common.requests.FetchResponse;
import org.apache.kafka010.common.requests.GroupCoordinatorResponse;
import org.apache.kafka010.common.requests.HeartbeatResponse;
import org.apache.kafka010.common.requests.JoinGroupResponse;
import org.apache.kafka010.common.requests.LeaderAndIsrResponse;
import org.apache.kafka010.common.requests.LeaveGroupResponse;
import org.apache.kafka010.common.requests.ListGroupsResponse;
import org.apache.kafka010.common.requests.ListOffsetResponse;
import org.apache.kafka010.common.requests.MetadataResponse;
import org.apache.kafka010.common.requests.OffsetCommitResponse;
import org.apache.kafka010.common.requests.OffsetFetchResponse;
import org.apache.kafka010.common.requests.ProduceResponse;
import org.apache.kafka010.common.requests.RequestHeader;
import org.apache.kafka010.common.requests.ResponseHeader;
import org.apache.kafka010.common.requests.SaslHandshakeResponse;
import org.apache.kafka010.common.requests.StopReplicaResponse;
import org.apache.kafka010.common.requests.SyncGroupResponse;
import org.apache.kafka010.common.requests.UpdateMetadataResponse;

public abstract class AbstractResponse
extends AbstractRequestResponse {
    public AbstractResponse(Struct struct) {
        super(struct);
    }

    public Send toSend(String destination, RequestHeader request) {
        ResponseHeader responseHeader = new ResponseHeader(request.correlationId());
        return new NetworkSend(destination, AbstractResponse.serialize(responseHeader, this));
    }

    public static AbstractResponse getResponse(int requestId, Struct struct) {
        ApiKeys apiKey = ApiKeys.forId(requestId);
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceResponse(struct);
            }
            case FETCH: {
                return new FetchResponse(struct);
            }
            case LIST_OFFSETS: {
                return new ListOffsetResponse(struct);
            }
            case METADATA: {
                return new MetadataResponse(struct);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitResponse(struct);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchResponse(struct);
            }
            case GROUP_COORDINATOR: {
                return new GroupCoordinatorResponse(struct);
            }
            case JOIN_GROUP: {
                return new JoinGroupResponse(struct);
            }
            case HEARTBEAT: {
                return new HeartbeatResponse(struct);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupResponse(struct);
            }
            case SYNC_GROUP: {
                return new SyncGroupResponse(struct);
            }
            case STOP_REPLICA: {
                return new StopReplicaResponse(struct);
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                return new ControlledShutdownResponse(struct);
            }
            case UPDATE_METADATA_KEY: {
                return new UpdateMetadataResponse(struct);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrResponse(struct);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsResponse(struct);
            }
            case LIST_GROUPS: {
                return new ListGroupsResponse(struct);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeResponse(struct);
            }
            case API_VERSIONS: {
                return new ApiVersionsResponse(struct);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsResponse(struct);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsResponse(struct);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `getResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }
}

