/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.Errors;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractRequest;
import org.apache.kafka010.common.requests.AbstractResponse;
import org.apache.kafka010.common.requests.DescribeGroupsResponse;
import org.apache.kafka010.common.utils.Utils;

public class DescribeGroupsRequest
extends AbstractRequest {
    private static final String GROUP_IDS_KEY_NAME = "group_ids";
    private final List<String> groupIds;

    private DescribeGroupsRequest(List<String> groupIds, short version) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.DESCRIBE_GROUPS.id, version)), version);
        this.struct.set(GROUP_IDS_KEY_NAME, (Object)groupIds.toArray());
        this.groupIds = groupIds;
    }

    public DescribeGroupsRequest(Struct struct, short version) {
        super(struct, version);
        this.groupIds = new ArrayList<String>();
        for (Object groupId : struct.getArray(GROUP_IDS_KEY_NAME)) {
            this.groupIds.add((String)groupId);
        }
    }

    public List<String> groupIds() {
        return this.groupIds;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return DescribeGroupsResponse.fromError(Errors.forException(e), this.groupIds);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.DESCRIBE_GROUPS.id)));
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer, int versionId) {
        return new DescribeGroupsRequest(ProtoUtils.parseRequest(ApiKeys.DESCRIBE_GROUPS.id, versionId, buffer), (short)versionId);
    }

    public static DescribeGroupsRequest parse(ByteBuffer buffer) {
        return DescribeGroupsRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.DESCRIBE_GROUPS.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeGroupsRequest> {
        private final List<String> groupIds;

        public Builder(List<String> groupIds) {
            super(ApiKeys.DESCRIBE_GROUPS);
            this.groupIds = groupIds;
        }

        @Override
        public DescribeGroupsRequest build() {
            short version = this.version();
            return new DescribeGroupsRequest(this.groupIds, version);
        }

        public String toString() {
            return "(type=DescribeGroupsRequest, groupIds=(" + Utils.join(this.groupIds, ",") + "))";
        }
    }
}

