/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.Errors;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractRequest;
import org.apache.kafka010.common.requests.AbstractResponse;
import org.apache.kafka010.common.requests.JoinGroupResponse;
import org.apache.kafka010.common.utils.Utils;

public class JoinGroupRequest
extends AbstractRequest {
    private static final String GROUP_ID_KEY_NAME = "group_id";
    private static final String SESSION_TIMEOUT_KEY_NAME = "session_timeout";
    private static final String REBALANCE_TIMEOUT_KEY_NAME = "rebalance_timeout";
    private static final String MEMBER_ID_KEY_NAME = "member_id";
    private static final String PROTOCOL_TYPE_KEY_NAME = "protocol_type";
    private static final String GROUP_PROTOCOLS_KEY_NAME = "group_protocols";
    private static final String PROTOCOL_NAME_KEY_NAME = "protocol_name";
    private static final String PROTOCOL_METADATA_KEY_NAME = "protocol_metadata";
    public static final String UNKNOWN_MEMBER_ID = "";
    private final String groupId;
    private final int sessionTimeout;
    private final int rebalanceTimeout;
    private final String memberId;
    private final String protocolType;
    private final List<ProtocolMetadata> groupProtocols;

    private JoinGroupRequest(short version, String groupId, int sessionTimeout, int rebalanceTimeout, String memberId, String protocolType, List<ProtocolMetadata> groupProtocols) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.JOIN_GROUP.id, version)), version);
        this.struct.set(GROUP_ID_KEY_NAME, (Object)groupId);
        this.struct.set(SESSION_TIMEOUT_KEY_NAME, (Object)sessionTimeout);
        if (version >= 1) {
            this.struct.set(REBALANCE_TIMEOUT_KEY_NAME, (Object)rebalanceTimeout);
        }
        this.struct.set(MEMBER_ID_KEY_NAME, (Object)memberId);
        this.struct.set(PROTOCOL_TYPE_KEY_NAME, (Object)protocolType);
        ArrayList<Struct> groupProtocolsList = new ArrayList<Struct>(groupProtocols.size());
        for (ProtocolMetadata protocol : groupProtocols) {
            Struct protocolStruct = this.struct.instance(GROUP_PROTOCOLS_KEY_NAME);
            protocolStruct.set(PROTOCOL_NAME_KEY_NAME, (Object)protocol.name);
            protocolStruct.set(PROTOCOL_METADATA_KEY_NAME, (Object)protocol.metadata);
            groupProtocolsList.add(protocolStruct);
        }
        this.struct.set(GROUP_PROTOCOLS_KEY_NAME, (Object)groupProtocolsList.toArray());
        this.groupId = groupId;
        this.sessionTimeout = sessionTimeout;
        this.rebalanceTimeout = rebalanceTimeout;
        this.memberId = memberId;
        this.protocolType = protocolType;
        this.groupProtocols = groupProtocols;
    }

    public JoinGroupRequest(Struct struct, short versionId) {
        super(struct, versionId);
        this.groupId = struct.getString(GROUP_ID_KEY_NAME);
        this.sessionTimeout = struct.getInt(SESSION_TIMEOUT_KEY_NAME);
        this.rebalanceTimeout = struct.hasField(REBALANCE_TIMEOUT_KEY_NAME) ? struct.getInt(REBALANCE_TIMEOUT_KEY_NAME) : this.sessionTimeout;
        this.memberId = struct.getString(MEMBER_ID_KEY_NAME);
        this.protocolType = struct.getString(PROTOCOL_TYPE_KEY_NAME);
        this.groupProtocols = new ArrayList<ProtocolMetadata>();
        for (Object groupProtocolObj : struct.getArray(GROUP_PROTOCOLS_KEY_NAME)) {
            Struct groupProtocolStruct = (Struct)groupProtocolObj;
            String name = groupProtocolStruct.getString(PROTOCOL_NAME_KEY_NAME);
            ByteBuffer metadata = groupProtocolStruct.getBytes(PROTOCOL_METADATA_KEY_NAME);
            this.groupProtocols.add(new ProtocolMetadata(name, metadata));
        }
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: 
            case 1: {
                return new JoinGroupResponse(versionId, Errors.forException(e).code(), -1, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, UNKNOWN_MEMBER_ID, Collections.emptyMap());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.JOIN_GROUP.id)));
    }

    public String groupId() {
        return this.groupId;
    }

    public int sessionTimeout() {
        return this.sessionTimeout;
    }

    public int rebalanceTimeout() {
        return this.rebalanceTimeout;
    }

    public String memberId() {
        return this.memberId;
    }

    public List<ProtocolMetadata> groupProtocols() {
        return this.groupProtocols;
    }

    public String protocolType() {
        return this.protocolType;
    }

    public static JoinGroupRequest parse(ByteBuffer buffer, int versionId) {
        return new JoinGroupRequest(ProtoUtils.parseRequest(ApiKeys.JOIN_GROUP.id, versionId, buffer), (short)versionId);
    }

    public static JoinGroupRequest parse(ByteBuffer buffer) {
        return JoinGroupRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.JOIN_GROUP.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<JoinGroupRequest> {
        private final String groupId;
        private final int sessionTimeout;
        private final String memberId;
        private final String protocolType;
        private final List<ProtocolMetadata> groupProtocols;
        private int rebalanceTimeout = 0;

        public Builder(String groupId, int sessionTimeout, String memberId, String protocolType, List<ProtocolMetadata> groupProtocols) {
            super(ApiKeys.JOIN_GROUP);
            this.groupId = groupId;
            this.sessionTimeout = sessionTimeout;
            this.rebalanceTimeout = sessionTimeout;
            this.memberId = memberId;
            this.protocolType = protocolType;
            this.groupProtocols = groupProtocols;
        }

        public Builder setRebalanceTimeout(int rebalanceTimeout) {
            this.rebalanceTimeout = rebalanceTimeout;
            return this;
        }

        @Override
        public JoinGroupRequest build() {
            short version = this.version();
            if (version < 1) {
                this.rebalanceTimeout = -1;
            }
            return new JoinGroupRequest(version, this.groupId, this.sessionTimeout, this.rebalanceTimeout, this.memberId, this.protocolType, this.groupProtocols);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type: JoinGroupRequest").append(", groupId=").append(this.groupId).append(", sessionTimeout=").append(this.sessionTimeout).append(", rebalanceTimeout=").append(this.rebalanceTimeout).append(", memberId=").append(this.memberId).append(", protocolType=").append(this.protocolType).append(", groupProtocols=").append(Utils.join(this.groupProtocols, ", ")).append(")");
            return bld.toString();
        }
    }

    public static class ProtocolMetadata {
        private final String name;
        private final ByteBuffer metadata;

        public ProtocolMetadata(String name, ByteBuffer metadata) {
            this.name = name;
            this.metadata = metadata;
        }

        public String name() {
            return this.name;
        }

        public ByteBuffer metadata() {
            return this.metadata;
        }
    }
}

