/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka010.common.TopicPartition;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Schema;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractResponse;
import org.apache.kafka010.common.utils.CollectionUtils;
import org.apache.kafka010.common.utils.Utils;

public class ListOffsetResponse
extends AbstractResponse {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    public static final long UNKNOWN_OFFSET = -1L;
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.LIST_OFFSETS.id);
    private static final String RESPONSES_KEY_NAME = "responses";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partition_responses";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    @Deprecated
    private static final String OFFSETS_KEY_NAME = "offsets";
    private static final String TIMESTAMP_KEY_NAME = "timestamp";
    private static final String OFFSET_KEY_NAME = "offset";
    private final Map<TopicPartition, PartitionData> responseData;

    @Deprecated
    public ListOffsetResponse(Map<TopicPartition, PartitionData> responseData) {
        this(responseData, 0);
    }

    public ListOffsetResponse(Map<TopicPartition, PartitionData> responseData, int version) {
        super(new Struct(ProtoUtils.responseSchema(ApiKeys.LIST_OFFSETS.id, version)));
        Map<String, Map<Integer, PartitionData>> topicsData = CollectionUtils.groupDataByTopic(responseData);
        ArrayList<Struct> topicArray = new ArrayList<Struct>();
        for (Map.Entry<String, Map<Integer, PartitionData>> topicEntry : topicsData.entrySet()) {
            Struct topicData = this.struct.instance(RESPONSES_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)topicEntry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, PartitionData> partitionEntry : topicEntry.getValue().entrySet()) {
                PartitionData offsetPartitionData = partitionEntry.getValue();
                Struct partitionData = topicData.instance(PARTITIONS_KEY_NAME);
                partitionData.set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey());
                partitionData.set(ERROR_CODE_KEY_NAME, (Object)offsetPartitionData.errorCode);
                if (version == 0) {
                    partitionData.set(OFFSETS_KEY_NAME, (Object)offsetPartitionData.offsets.toArray());
                } else {
                    partitionData.set(TIMESTAMP_KEY_NAME, (Object)offsetPartitionData.timestamp);
                    partitionData.set(OFFSET_KEY_NAME, (Object)offsetPartitionData.offset);
                }
                partitionArray.add(partitionData);
            }
            topicData.set(PARTITIONS_KEY_NAME, (Object)partitionArray.toArray());
            topicArray.add(topicData);
        }
        this.struct.set(RESPONSES_KEY_NAME, (Object)topicArray.toArray());
        this.responseData = responseData;
    }

    public ListOffsetResponse(Struct struct) {
        super(struct);
        this.responseData = new HashMap<TopicPartition, PartitionData>();
        for (Object topicResponseObj : struct.getArray(RESPONSES_KEY_NAME)) {
            Struct topicResponse = (Struct)topicResponseObj;
            String topic = topicResponse.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicResponse.getArray(PARTITIONS_KEY_NAME)) {
                PartitionData partitionData;
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                short errorCode = partitionResponse.getShort(ERROR_CODE_KEY_NAME);
                if (partitionResponse.hasField(OFFSETS_KEY_NAME)) {
                    Object[] offsets = partitionResponse.getArray(OFFSETS_KEY_NAME);
                    ArrayList<Long> offsetsList = new ArrayList<Long>();
                    for (Object offset : offsets) {
                        offsetsList.add((Long)offset);
                    }
                    partitionData = new PartitionData(errorCode, offsetsList);
                } else {
                    long timestamp = partitionResponse.getLong(TIMESTAMP_KEY_NAME);
                    long offset = partitionResponse.getLong(OFFSET_KEY_NAME);
                    partitionData = new PartitionData(errorCode, timestamp, offset);
                }
                this.responseData.put(new TopicPartition(topic, partition), partitionData);
            }
        }
    }

    public Map<TopicPartition, PartitionData> responseData() {
        return this.responseData;
    }

    public static ListOffsetResponse parse(ByteBuffer buffer) {
        return new ListOffsetResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static ListOffsetResponse parse(ByteBuffer buffer, int version) {
        return new ListOffsetResponse(ProtoUtils.responseSchema(ApiKeys.LIST_OFFSETS.id, version).read(buffer));
    }

    public static final class PartitionData {
        public final short errorCode;
        @Deprecated
        public final List<Long> offsets;
        public final Long timestamp;
        public final Long offset;

        @Deprecated
        public PartitionData(short errorCode, List<Long> offsets) {
            this.errorCode = errorCode;
            this.offsets = offsets;
            this.timestamp = null;
            this.offset = null;
        }

        public PartitionData(short errorCode, long timestamp, long offset) {
            this.errorCode = errorCode;
            this.timestamp = timestamp;
            this.offset = offset;
            this.offsets = null;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("PartitionData{").append("errorCode: ").append(this.errorCode).append(", timestamp: ").append(this.timestamp).append(", offset: ").append(this.offset).append(", offsets: ");
            if (this.offsets == null) {
                bld.append(this.offsets);
            } else {
                bld.append("[").append(Utils.join(this.offsets, ",")).append("]");
            }
            bld.append("}");
            return bld.toString();
        }
    }
}

