/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka010.common.protocol.Protocol;
import org.apache.kafka010.common.protocol.types.Field;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractRequestResponse;

public class RequestHeader
extends AbstractRequestResponse {
    private static final Field API_KEY_FIELD = Protocol.REQUEST_HEADER.get("api_key");
    private static final Field API_VERSION_FIELD = Protocol.REQUEST_HEADER.get("api_version");
    private static final Field CLIENT_ID_FIELD = Protocol.REQUEST_HEADER.get("client_id");
    private static final Field CORRELATION_ID_FIELD = Protocol.REQUEST_HEADER.get("correlation_id");
    private final short apiKey;
    private final short apiVersion;
    private final String clientId;
    private final int correlationId;

    public RequestHeader(Struct header) {
        super(header);
        this.apiKey = this.struct.getShort(API_KEY_FIELD);
        this.apiVersion = this.struct.getShort(API_VERSION_FIELD);
        this.clientId = this.struct.getString(CLIENT_ID_FIELD);
        this.correlationId = this.struct.getInt(CORRELATION_ID_FIELD);
    }

    public RequestHeader(short apiKey, short version, String client, int correlation) {
        super(new Struct(Protocol.REQUEST_HEADER));
        this.struct.set(API_KEY_FIELD, (Object)apiKey);
        this.struct.set(API_VERSION_FIELD, (Object)version);
        this.struct.set(CLIENT_ID_FIELD, (Object)client);
        this.struct.set(CORRELATION_ID_FIELD, (Object)correlation);
        this.apiKey = apiKey;
        this.apiVersion = version;
        this.clientId = client;
        this.correlationId = correlation;
    }

    public short apiKey() {
        return this.apiKey;
    }

    public short apiVersion() {
        return this.apiVersion;
    }

    public String clientId() {
        return this.clientId;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public static RequestHeader parse(ByteBuffer buffer) {
        return new RequestHeader(Protocol.REQUEST_HEADER.read(buffer));
    }
}

