/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.Header;
import io.streamnative.kafka.client.api.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;

public class ConsumerRecord<K, V> {
    private final K key;
    private final V value;
    private final String topic;
    private final int partition;
    private final long offset;
    private final List<Header> headers;

    public static <K, V, T> ConsumerRecord<K, V> create(T originalRecord) {
        Class<?> clazz = originalRecord.getClass();
        Object originalHeaders = ReflectionUtils.invoke(clazz, "headers", originalRecord);
        List<Header> headers = Header.fromHeaders((Object[])ReflectionUtils.invoke(originalHeaders.getClass(), "toArray", originalHeaders));
        return new ConsumerRecord<Object, Object>(ReflectionUtils.invoke(clazz, "key", originalRecord), ReflectionUtils.invoke(clazz, "value", originalRecord), (String)ReflectionUtils.invoke(clazz, "topic", originalRecord), (Integer)ReflectionUtils.invoke(clazz, "partition", originalRecord), (Long)ReflectionUtils.invoke(clazz, "offset", originalRecord), headers);
    }

    public static <K, V, T> ConsumerRecord<K, V> createOldRecord(T originalRecord) {
        Class<?> clazz = originalRecord.getClass();
        ArrayList<Header> headerList = new ArrayList<Header>();
        headerList.add(new Header(null, null));
        return new ConsumerRecord<Object, Object>(ReflectionUtils.invoke(clazz, "key", originalRecord), ReflectionUtils.invoke(clazz, "value", originalRecord), (String)ReflectionUtils.invoke(clazz, "topic", originalRecord), (Integer)ReflectionUtils.invoke(clazz, "partition", originalRecord), (Long)ReflectionUtils.invoke(clazz, "offset", originalRecord), headerList);
    }

    public ConsumerRecord(K key, V value, String topic, int partition, long offset, List<Header> headers) {
        this.key = key;
        this.value = value;
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
        this.headers = headers;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }
}

