/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.ReflectionUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class Header {
    private final String key;
    private final String value;

    private static Header fromHeader(Object originalHeader) {
        if (originalHeader == null) {
            return null;
        }
        Class<?> clazz = originalHeader.getClass();
        return new Header((String)ReflectionUtils.invoke(clazz, "key", originalHeader), new String((byte[])ReflectionUtils.invoke(clazz, "value", originalHeader), StandardCharsets.UTF_8));
    }

    public static List<Header> fromHeaders(Object[] originalHeaders) {
        if (originalHeaders == null || originalHeaders.length == 0) {
            return null;
        }
        ArrayList<Header> headers = new ArrayList<Header>();
        for (Object header : originalHeaders) {
            headers.add(Header.fromHeader(header));
        }
        return headers;
    }

    public static <T> List<T> toHeaders(List<Header> headers, BiFunction<String, byte[], T> constructor) {
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        return headers.stream().map(header -> header != null ? constructor.apply(header.getKey(), header.getValue().getBytes(StandardCharsets.UTF_8)) : null).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.key, header.key) && Objects.equals(this.value, header.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    public Header(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

