/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import java.util.Properties;

public class ProducerConfiguration {
    private String bootstrapServers;
    private Object keySerializer;
    private Object valueSerializer;
    private String maxBlockMs;
    private String securityProtocol;
    private String saslMechanism;
    private String userName;
    private String password;

    public Properties toProperties() {
        Properties props = new Properties();
        if (this.bootstrapServers != null) {
            props.put("bootstrap.servers", this.bootstrapServers);
        }
        if (this.keySerializer != null) {
            props.put("key.serializer", this.keySerializer);
        }
        if (this.valueSerializer != null) {
            props.put("value.serializer", this.valueSerializer);
        }
        if (this.maxBlockMs != null) {
            props.put("max.block.ms", this.maxBlockMs);
        }
        if (this.securityProtocol != null) {
            props.put("security.protocol", this.securityProtocol);
        }
        if (this.saslMechanism != null) {
            props.put("sasl.mechanism", this.saslMechanism);
        }
        if (this.userName != null && this.password != null) {
            String kafkaAuth = String.format("username=\"%s\" password=\"%s\";", this.userName, this.password);
            props.put("sasl.jaas.config", "org.apache.kafka010.common.security.plain.PlainLoginModule required " + kafkaAuth);
        }
        return props;
    }

    ProducerConfiguration(String bootstrapServers, Object keySerializer, Object valueSerializer, String maxBlockMs, String securityProtocol, String saslMechanism, String userName, String password) {
        this.bootstrapServers = bootstrapServers;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.maxBlockMs = maxBlockMs;
        this.securityProtocol = securityProtocol;
        this.saslMechanism = saslMechanism;
        this.userName = userName;
        this.password = password;
    }

    public static ProducerConfigurationBuilder builder() {
        return new ProducerConfigurationBuilder();
    }

    public static class ProducerConfigurationBuilder {
        private String bootstrapServers;
        private Object keySerializer;
        private Object valueSerializer;
        private String maxBlockMs;
        private String securityProtocol;
        private String saslMechanism;
        private String userName;
        private String password;

        ProducerConfigurationBuilder() {
        }

        public ProducerConfigurationBuilder bootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
            return this;
        }

        public ProducerConfigurationBuilder keySerializer(Object keySerializer) {
            this.keySerializer = keySerializer;
            return this;
        }

        public ProducerConfigurationBuilder valueSerializer(Object valueSerializer) {
            this.valueSerializer = valueSerializer;
            return this;
        }

        public ProducerConfigurationBuilder maxBlockMs(String maxBlockMs) {
            this.maxBlockMs = maxBlockMs;
            return this;
        }

        public ProducerConfigurationBuilder securityProtocol(String securityProtocol) {
            this.securityProtocol = securityProtocol;
            return this;
        }

        public ProducerConfigurationBuilder saslMechanism(String saslMechanism) {
            this.saslMechanism = saslMechanism;
            return this;
        }

        public ProducerConfigurationBuilder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public ProducerConfigurationBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ProducerConfiguration build() {
            return new ProducerConfiguration(this.bootstrapServers, this.keySerializer, this.valueSerializer, this.maxBlockMs, this.securityProtocol, this.saslMechanism, this.userName, this.password);
        }

        public String toString() {
            return "ProducerConfiguration.ProducerConfigurationBuilder(bootstrapServers=" + this.bootstrapServers + ", keySerializer=" + this.keySerializer + ", valueSerializer=" + this.valueSerializer + ", maxBlockMs=" + this.maxBlockMs + ", securityProtocol=" + this.securityProtocol + ", saslMechanism=" + this.saslMechanism + ", userName=" + this.userName + ", password=" + this.password + ")";
        }
    }
}

