/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.clients;

import org.apache.kafka010.clients.RequestCompletionHandler;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.requests.AbstractRequest;
import org.apache.kafka010.common.requests.RequestHeader;

public final class ClientRequest {
    private final String destination;
    private final AbstractRequest.Builder<?> requestBuilder;
    private final int correlationId;
    private final String clientId;
    private final long createdTimeMs;
    private final boolean expectResponse;
    private final RequestCompletionHandler callback;

    public ClientRequest(String destination, AbstractRequest.Builder<?> requestBuilder, int correlationId, String clientId, long createdTimeMs, boolean expectResponse, RequestCompletionHandler callback) {
        this.destination = destination;
        this.requestBuilder = requestBuilder;
        this.correlationId = correlationId;
        this.clientId = clientId;
        this.createdTimeMs = createdTimeMs;
        this.expectResponse = expectResponse;
        this.callback = callback;
    }

    public String toString() {
        return "ClientRequest(expectResponse=" + this.expectResponse + ", callback=" + this.callback + ", destination=" + this.destination + ", correlationId=" + this.correlationId + ", clientId=" + this.clientId + ", createdTimeMs=" + this.createdTimeMs + ", requestBuilder=" + this.requestBuilder + ")";
    }

    public boolean expectResponse() {
        return this.expectResponse;
    }

    public ApiKeys apiKey() {
        return this.requestBuilder.apiKey();
    }

    public RequestHeader makeHeader() {
        return new RequestHeader(this.requestBuilder.apiKey().id, this.requestBuilder.version(), this.clientId, this.correlationId);
    }

    public AbstractRequest.Builder<?> requestBuilder() {
        return this.requestBuilder;
    }

    public String destination() {
        return this.destination;
    }

    public RequestCompletionHandler callback() {
        return this.callback;
    }

    public long createdTimeMs() {
        return this.createdTimeMs;
    }

    public int correlationId() {
        return this.correlationId;
    }
}

