/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.clients.consumer.internals;

import java.io.Closeable;
import java.util.List;
import java.util.Map;
import org.apache.kafka010.clients.consumer.ConsumerInterceptor;
import org.apache.kafka010.clients.consumer.ConsumerRecords;
import org.apache.kafka010.clients.consumer.OffsetAndMetadata;
import org.apache.kafka010.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerInterceptors<K, V>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ConsumerInterceptors.class);
    private final List<ConsumerInterceptor<K, V>> interceptors;

    public ConsumerInterceptors(List<ConsumerInterceptor<K, V>> interceptors) {
        this.interceptors = interceptors;
    }

    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        ConsumerRecords<K, V> interceptRecords = records;
        for (ConsumerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptRecords = interceptor.onConsume(interceptRecords);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onConsume callback", e);
            }
        }
        return interceptRecords;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> offsets) {
        for (ConsumerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptor.onCommit(offsets);
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onCommit callback", e);
            }
        }
    }

    @Override
    public void close() {
        for (ConsumerInterceptor<K, V> interceptor : this.interceptors) {
            try {
                interceptor.close();
            }
            catch (Exception e) {
                log.error("Failed to close consumer interceptor ", e);
            }
        }
    }
}

