/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.clients.producer.internals;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka010.common.TopicPartition;

public final class ProduceRequestResult {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final TopicPartition topicPartition;
    private volatile Long baseOffset = null;
    private volatile long logAppendTime = -1L;
    private volatile RuntimeException error;

    public ProduceRequestResult(TopicPartition topicPartition) {
        this.topicPartition = topicPartition;
    }

    public void set(long baseOffset, long logAppendTime, RuntimeException error) {
        this.baseOffset = baseOffset;
        this.logAppendTime = logAppendTime;
        this.error = error;
    }

    public void done() {
        if (this.baseOffset == null) {
            throw new IllegalStateException("The method `set` must be invoked before this method.");
        }
        this.latch.countDown();
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    public boolean hasLogAppendTime() {
        return this.logAppendTime != -1L;
    }

    public long logAppendTime() {
        return this.logAppendTime;
    }

    public RuntimeException error() {
        return this.error;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public boolean completed() {
        return this.latch.getCount() == 0L;
    }
}

