/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.kafka010.common.MetricName;
import org.apache.kafka010.common.metrics.CompoundStat;
import org.apache.kafka010.common.metrics.KafkaMetric;
import org.apache.kafka010.common.metrics.MeasurableStat;
import org.apache.kafka010.common.metrics.MetricConfig;
import org.apache.kafka010.common.metrics.Metrics;
import org.apache.kafka010.common.metrics.Quota;
import org.apache.kafka010.common.metrics.QuotaViolationException;
import org.apache.kafka010.common.metrics.Stat;
import org.apache.kafka010.common.utils.Time;
import org.apache.kafka010.common.utils.Utils;

public final class Sensor {
    private final Metrics registry;
    private final String name;
    private final Sensor[] parents;
    private final List<Stat> stats;
    private final List<KafkaMetric> metrics;
    private final MetricConfig config;
    private final Time time;
    private volatile long lastRecordTime;
    private final long inactiveSensorExpirationTimeMs;
    private final RecordingLevel recordingLevel;

    Sensor(Metrics registry, String name, Sensor[] parents, MetricConfig config, Time time, long inactiveSensorExpirationTimeSeconds, RecordingLevel recordingLevel) {
        this.registry = registry;
        this.name = Utils.notNull(name);
        this.parents = parents == null ? new Sensor[]{} : parents;
        this.metrics = new ArrayList<KafkaMetric>();
        this.stats = new ArrayList<Stat>();
        this.config = config;
        this.time = time;
        this.inactiveSensorExpirationTimeMs = TimeUnit.MILLISECONDS.convert(inactiveSensorExpirationTimeSeconds, TimeUnit.SECONDS);
        this.lastRecordTime = time.milliseconds();
        this.recordingLevel = recordingLevel;
        this.checkForest(new HashSet<Sensor>());
    }

    private void checkForest(Set<Sensor> sensors) {
        if (!sensors.add(this)) {
            throw new IllegalArgumentException("Circular dependency in sensors: " + this.name() + " is its own parent.");
        }
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i].checkForest(sensors);
        }
    }

    public String name() {
        return this.name;
    }

    public void record() {
        if (this.shouldRecord()) {
            this.record(1.0);
        }
    }

    public boolean shouldRecord() {
        return this.recordingLevel.shouldRecord(this.config.recordLevel().id);
    }

    public void record(double value) {
        if (this.shouldRecord()) {
            this.record(value, this.time.milliseconds());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(double value, long timeMs) {
        if (this.shouldRecord()) {
            this.lastRecordTime = timeMs;
            Sensor sensor = this;
            synchronized (sensor) {
                for (int i = 0; i < this.stats.size(); ++i) {
                    this.stats.get(i).record(this.config, value, timeMs);
                }
                this.checkQuotas(timeMs);
            }
            for (int i = 0; i < this.parents.length; ++i) {
                this.parents[i].record(value, timeMs);
            }
        }
    }

    public void checkQuotas() {
        this.checkQuotas(this.time.milliseconds());
    }

    public void checkQuotas(long timeMs) {
        for (int i = 0; i < this.metrics.size(); ++i) {
            double value;
            Quota quota;
            KafkaMetric metric = this.metrics.get(i);
            MetricConfig config = metric.config();
            if (config == null || (quota = config.quota()) == null || quota.acceptable(value = metric.value(timeMs))) continue;
            throw new QuotaViolationException(metric.metricName(), value, quota.bound());
        }
    }

    public void add(CompoundStat stat) {
        this.add(stat, null);
    }

    public synchronized void add(CompoundStat stat, MetricConfig config) {
        this.stats.add(Utils.notNull(stat));
        for (CompoundStat.NamedMeasurable m : stat.stats()) {
            KafkaMetric metric = new KafkaMetric(this, m.name(), m.stat(), config == null ? this.config : config, this.time);
            this.registry.registerMetric(metric);
            this.metrics.add(metric);
        }
    }

    public void add(MetricName metricName, MeasurableStat stat) {
        this.add(metricName, stat, null);
    }

    public synchronized void add(MetricName metricName, MeasurableStat stat, MetricConfig config) {
        KafkaMetric metric = new KafkaMetric(new Object(), Utils.notNull(metricName), Utils.notNull(stat), config == null ? this.config : config, this.time);
        this.registry.registerMetric(metric);
        this.metrics.add(metric);
        this.stats.add(stat);
    }

    public boolean hasExpired() {
        return this.time.milliseconds() - this.lastRecordTime > this.inactiveSensorExpirationTimeMs;
    }

    synchronized List<KafkaMetric> metrics() {
        return Collections.unmodifiableList(this.metrics);
    }

    public static enum RecordingLevel {
        INFO(0, "INFO"),
        DEBUG(1, "DEBUG");

        private static final RecordingLevel[] ID_TO_TYPE;
        private static final int MIN_RECORDING_LEVEL_KEY = 0;
        public static final int MAX_RECORDING_LEVEL_KEY;
        public final String name;
        public final short id;

        private RecordingLevel(int id, String name) {
            this.id = (short)id;
            this.name = name;
        }

        public static RecordingLevel forId(int id) {
            if (id < 0 || id > MAX_RECORDING_LEVEL_KEY) {
                throw new IllegalArgumentException(String.format("Unexpected RecordLevel id `%s`, it should be between `%s` and `%s` (inclusive)", id, 0, MAX_RECORDING_LEVEL_KEY));
            }
            return ID_TO_TYPE[id];
        }

        public static RecordingLevel forName(String name) {
            return RecordingLevel.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public boolean shouldRecord(int configId) {
            if (configId == RecordingLevel.DEBUG.id) {
                return true;
            }
            return configId == this.id;
        }

        static {
            int maxRL = -1;
            for (RecordingLevel level : RecordingLevel.values()) {
                maxRL = Math.max(maxRL, level.id);
            }
            RecordingLevel[] idToName = new RecordingLevel[maxRL + 1];
            RecordingLevel[] arr$ = RecordingLevel.values();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                RecordingLevel level;
                idToName[level.id] = level = arr$[i$];
            }
            ID_TO_TYPE = idToName;
            MAX_RECORDING_LEVEL_KEY = maxRL;
        }
    }
}

