/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Schema;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractResponse;

public class HeartbeatResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.HEARTBEAT.id);
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final short errorCode;

    public HeartbeatResponse(short errorCode) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        this.errorCode = errorCode;
    }

    public HeartbeatResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public static HeartbeatResponse parse(ByteBuffer buffer) {
        return new HeartbeatResponse(CURRENT_SCHEMA.read(buffer));
    }
}

