/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka010.common.TopicPartition;
import org.apache.kafka010.common.errors.UnsupportedVersionException;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.Errors;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.record.MemoryRecords;
import org.apache.kafka010.common.requests.AbstractRequest;
import org.apache.kafka010.common.requests.AbstractResponse;
import org.apache.kafka010.common.requests.ProduceResponse;
import org.apache.kafka010.common.utils.CollectionUtils;
import org.apache.kafka010.common.utils.Utils;

public class ProduceRequest
extends AbstractRequest {
    private static final String ACKS_KEY_NAME = "acks";
    private static final String TIMEOUT_KEY_NAME = "timeout";
    private static final String TOPIC_DATA_KEY_NAME = "topic_data";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_DATA_KEY_NAME = "data";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String RECORD_SET_KEY_NAME = "record_set";
    private final short acks;
    private final int timeout;
    private final Map<TopicPartition, Integer> partitionSizes;
    private volatile Map<TopicPartition, MemoryRecords> partitionRecords;

    private ProduceRequest(short version, short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords) {
        super(new Struct(ProtoUtils.requestSchema(ApiKeys.PRODUCE.id, version)), version);
        Map<String, Map<Integer, MemoryRecords>> recordsByTopic = CollectionUtils.groupDataByTopic(partitionRecords);
        this.struct.set(ACKS_KEY_NAME, (Object)acks);
        this.struct.set(TIMEOUT_KEY_NAME, (Object)timeout);
        ArrayList<Struct> topicDatas = new ArrayList<Struct>(recordsByTopic.size());
        for (Map.Entry<String, Map<Integer, MemoryRecords>> entry : recordsByTopic.entrySet()) {
            Struct topicData = this.struct.instance(TOPIC_DATA_KEY_NAME);
            topicData.set(TOPIC_KEY_NAME, (Object)entry.getKey());
            ArrayList<Struct> partitionArray = new ArrayList<Struct>();
            for (Map.Entry<Integer, MemoryRecords> partitionEntry : entry.getValue().entrySet()) {
                MemoryRecords records = partitionEntry.getValue();
                Struct part = topicData.instance(PARTITION_DATA_KEY_NAME).set(PARTITION_KEY_NAME, (Object)partitionEntry.getKey()).set(RECORD_SET_KEY_NAME, (Object)records);
                partitionArray.add(part);
            }
            topicData.set(PARTITION_DATA_KEY_NAME, (Object)partitionArray.toArray());
            topicDatas.add(topicData);
        }
        this.struct.set(TOPIC_DATA_KEY_NAME, (Object)topicDatas.toArray());
        this.acks = acks;
        this.timeout = timeout;
        this.partitionRecords = partitionRecords;
        this.partitionSizes = ProduceRequest.createPartitionSizes(partitionRecords);
    }

    private static Map<TopicPartition, Integer> createPartitionSizes(Map<TopicPartition, MemoryRecords> partitionRecords) {
        HashMap<TopicPartition, Integer> result = new HashMap<TopicPartition, Integer>(partitionRecords.size());
        for (Map.Entry<TopicPartition, MemoryRecords> entry : partitionRecords.entrySet()) {
            result.put(entry.getKey(), entry.getValue().sizeInBytes());
        }
        return result;
    }

    public ProduceRequest(Struct struct, short version) {
        super(struct, version);
        this.partitionRecords = new HashMap<TopicPartition, MemoryRecords>();
        for (Object topicDataObj : struct.getArray(TOPIC_DATA_KEY_NAME)) {
            Struct topicData = (Struct)topicDataObj;
            String topic = topicData.getString(TOPIC_KEY_NAME);
            for (Object partitionResponseObj : topicData.getArray(PARTITION_DATA_KEY_NAME)) {
                Struct partitionResponse = (Struct)partitionResponseObj;
                int partition = partitionResponse.getInt(PARTITION_KEY_NAME);
                MemoryRecords records = (MemoryRecords)partitionResponse.getRecords(RECORD_SET_KEY_NAME);
                this.partitionRecords.put(new TopicPartition(topic, partition), records);
            }
        }
        this.partitionSizes = ProduceRequest.createPartitionSizes(this.partitionRecords);
        this.acks = struct.getShort(ACKS_KEY_NAME);
        this.timeout = struct.getInt(TIMEOUT_KEY_NAME);
    }

    @Override
    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("{acks=").append(this.acks).append(",timeout=").append(this.timeout).append(",partitionSizes=").append(Utils.mkString(this.partitionSizes, "[", "]", "=", ",")).append("}");
        return bld.toString();
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        if (this.acks == 0) {
            return null;
        }
        HashMap<TopicPartition, ProduceResponse.PartitionResponse> responseMap = new HashMap<TopicPartition, ProduceResponse.PartitionResponse>();
        ProduceResponse.PartitionResponse partitionResponse = new ProduceResponse.PartitionResponse(Errors.forException(e));
        for (TopicPartition tp : this.partitions()) {
            responseMap.put(tp, partitionResponse);
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new ProduceResponse(responseMap);
            }
            case 1: 
            case 2: {
                return new ProduceResponse(responseMap, 0, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.PRODUCE.id)));
    }

    private Collection<TopicPartition> partitions() {
        return this.partitionSizes.keySet();
    }

    public short acks() {
        return this.acks;
    }

    public int timeout() {
        return this.timeout;
    }

    public Map<TopicPartition, MemoryRecords> partitionRecordsOrFail() {
        Map<TopicPartition, MemoryRecords> partitionRecords = this.partitionRecords;
        if (partitionRecords == null) {
            throw new IllegalStateException("The partition records are no longer available because clearPartitionRecords() has been invoked.");
        }
        return partitionRecords;
    }

    public void clearPartitionRecords() {
        this.partitionRecords = null;
        this.struct.clear();
    }

    public static ProduceRequest parse(ByteBuffer buffer, int versionId) {
        return new ProduceRequest(ProtoUtils.parseRequest(ApiKeys.PRODUCE.id, versionId, buffer), (short)versionId);
    }

    public static ProduceRequest parse(ByteBuffer buffer) {
        return ProduceRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.PRODUCE.id));
    }

    public static class Builder
    extends AbstractRequest.Builder<ProduceRequest> {
        private final short acks;
        private final int timeout;
        private final Map<TopicPartition, MemoryRecords> partitionRecords;

        public Builder(short acks, int timeout, Map<TopicPartition, MemoryRecords> partitionRecords) {
            super(ApiKeys.PRODUCE);
            this.acks = acks;
            this.timeout = timeout;
            this.partitionRecords = partitionRecords;
        }

        @Override
        public ProduceRequest build() {
            short version = this.version();
            if (version < 2) {
                throw new UnsupportedVersionException("ProduceRequest versions older than 2 are not supported.");
            }
            return new ProduceRequest(version, this.acks, this.timeout, this.partitionRecords);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=ProduceRequest").append(", acks=").append(this.acks).append(", timeout=").append(this.timeout).append(", partitionRecords=(").append(Utils.mkString(this.partitionRecords)).append("))");
            return bld.toString();
        }
    }
}

