/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka010.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.kafka010.common.protocol.ApiKeys;
import org.apache.kafka010.common.protocol.Errors;
import org.apache.kafka010.common.protocol.ProtoUtils;
import org.apache.kafka010.common.protocol.types.Schema;
import org.apache.kafka010.common.protocol.types.Struct;
import org.apache.kafka010.common.requests.AbstractRequest;
import org.apache.kafka010.common.requests.AbstractResponse;
import org.apache.kafka010.common.requests.SaslHandshakeResponse;

public class SaslHandshakeRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.SASL_HANDSHAKE.id);
    public static final String MECHANISM_KEY_NAME = "mechanism";
    private final String mechanism;

    public SaslHandshakeRequest(String mechanism) {
        super(new Struct(CURRENT_SCHEMA), ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id));
        this.struct.set(MECHANISM_KEY_NAME, (Object)mechanism);
        this.mechanism = mechanism;
    }

    public SaslHandshakeRequest(Struct struct, short versionId) {
        super(struct, versionId);
        this.mechanism = struct.getString(MECHANISM_KEY_NAME);
    }

    public String mechanism() {
        return this.mechanism;
    }

    @Override
    public AbstractResponse getErrorResponse(Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                List<String> enabledMechanisms = Collections.emptyList();
                return new SaslHandshakeResponse(Errors.forException(e).code(), enabledMechanisms);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id)));
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer, int versionId) {
        return new SaslHandshakeRequest(ProtoUtils.parseRequest(ApiKeys.SASL_HANDSHAKE.id, versionId, buffer), (short)versionId);
    }

    public static SaslHandshakeRequest parse(ByteBuffer buffer) {
        return SaslHandshakeRequest.parse(buffer, ProtoUtils.latestVersion(ApiKeys.SASL_HANDSHAKE.id));
    }
}

