/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.ConsumerRecord;
import io.streamnative.kafka.client.api.TopicOffsetAndMetadata;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.apache.kafka.common.PartitionInfo;

public interface Consumer<K, V>
extends Closeable {
    public void subscribe(Collection<String> var1);

    default public void subscribe(String topic) {
        this.subscribe(Collections.singleton(topic));
    }

    @NonNull
    public List<ConsumerRecord<K, V>> receive(long var1);

    default public List<ConsumerRecord<K, V>> receiveUntil(int maxNumMessages, long timeoutMs) {
        int pollTimeoutMs = 100;
        ArrayList records = new ArrayList();
        AtomicInteger numReceived = new AtomicInteger(0);
        for (long elapsedTimeMs = 0L; numReceived.get() < maxNumMessages && elapsedTimeMs < timeoutMs; elapsedTimeMs += 100L) {
            this.receive(100L).forEach(record -> {
                records.add((ConsumerRecord)record);
                numReceived.incrementAndGet();
            });
        }
        return records;
    }

    public Map<String, List<PartitionInfo>> listTopics(long var1);

    public void commitOffsetSync(List<TopicOffsetAndMetadata> var1, Duration var2);
}

