/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

public enum KafkaVersion {
    DEFAULT("default"),
    KAFKA_3_0_0("300"),
    KAFKA_2_8_0("280"),
    KAFKA_1_0_0("100"),
    KAFKA_0_10_0_0("010"),
    KAFKA_0_9_0_0("009");

    private String name;

    private KafkaVersion(String name) {
        this.name = name;
    }

    public String getStringSerializer() {
        if (this.equals((Object)DEFAULT)) {
            return "org.apache.kafka.common.serialization.StringSerializer";
        }
        return String.format("org.apache.kafka%s.common.serialization.StringSerializer", this.name);
    }

    public String getStringDeserializer() {
        if (this.equals((Object)DEFAULT)) {
            return "org.apache.kafka.common.serialization.StringDeserializer";
        }
        return String.format("org.apache.kafka%s.common.serialization.StringDeserializer", this.name);
    }

    public boolean supportHeader() {
        return !this.equals((Object)KAFKA_0_9_0_0) && !this.equals((Object)KAFKA_0_10_0_0);
    }

    public boolean supportSaslPlainAuthentication() {
        return !this.equals((Object)KAFKA_0_9_0_0);
    }

    public String getName() {
        return this.name;
    }
}

