/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.ReflectionUtils;

public class RecordMetadata {
    private final String topic;
    private final int partition;
    private final long offset;

    public String toString() {
        return this.topic + "-" + this.partition + "@" + this.offset;
    }

    public static <T> RecordMetadata create(T originalMetadata) {
        Class<?> clazz = originalMetadata.getClass();
        return new RecordMetadata((String)ReflectionUtils.invoke(clazz, "topic", originalMetadata), (Integer)ReflectionUtils.invoke(clazz, "partition", originalMetadata), (Long)ReflectionUtils.invoke(clazz, "offset", originalMetadata));
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getOffset() {
        return this.offset;
    }

    public RecordMetadata(String topic, int partition, long offset) {
        this.topic = topic;
        this.partition = partition;
        this.offset = offset;
    }
}

