/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.kafka.client.api;

import io.streamnative.kafka.client.api.Consumer;
import io.streamnative.kafka.client.api.ConsumerConfiguration;
import io.streamnative.kafka.client.api.KafkaClientFactory;
import io.streamnative.kafka.client.api.KafkaVersion;
import io.streamnative.kafka.client.api.Producer;
import io.streamnative.kafka.client.api.ProducerConfiguration;
import io.streamnative.kafka.client.one.zero.ConsumerImpl;
import io.streamnative.kafka.client.one.zero.ProducerImpl;
import io.streamnative.kafka.client.three.zero.Consumer300Impl;
import io.streamnative.kafka.client.three.zero.Producer300Impl;
import io.streamnative.kafka.client.two.eight.Consumer280Impl;
import io.streamnative.kafka.client.two.eight.Producer280Impl;
import io.streamnative.kafka.client.zero.nine.Consumer009Impl;
import io.streamnative.kafka.client.zero.nine.Producer009Impl;
import io.streamnative.kafka.client.zero.ten.Consumer010Impl;
import io.streamnative.kafka.client.zero.ten.Producer010Impl;

public class KafkaClientFactoryImpl
implements KafkaClientFactory {
    private KafkaVersion kafkaVersion;

    public KafkaClientFactoryImpl(KafkaVersion kafkaVersion) {
        this.kafkaVersion = kafkaVersion;
    }

    @Override
    public <K, V> Producer<K, V> createProducer(ProducerConfiguration conf) {
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_1_0_0)) {
            return new ProducerImpl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_0_10_0_0)) {
            return new Producer010Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_2_8_0)) {
            return new Producer280Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_3_0_0)) {
            return new Producer300Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_0_9_0_0)) {
            return new Producer009Impl(conf);
        }
        throw new IllegalArgumentException("No producer for version: " + this.kafkaVersion);
    }

    @Override
    public <K, V> Consumer<K, V> createConsumer(ConsumerConfiguration conf) {
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_1_0_0)) {
            return new ConsumerImpl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_0_10_0_0)) {
            return new Consumer010Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_2_8_0)) {
            return new Consumer280Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_3_0_0)) {
            return new Consumer300Impl(conf);
        }
        if (this.kafkaVersion.equals((Object)KafkaVersion.KAFKA_0_9_0_0)) {
            return new Consumer009Impl(conf);
        }
        throw new IllegalArgumentException("No consumer for version: " + this.kafkaVersion);
    }
}

