/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.streamnative.pulsar.handlers.kop.EndPoint;
import io.streamnative.pulsar.handlers.kop.KopVersion;
import io.streamnative.pulsar.handlers.kop.proxy.KafkaProxyChannelInitializer;
import io.streamnative.pulsar.handlers.kop.proxy.KafkaProxyConfiguration;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.pulsar.proxy.extensions.ProxyExtension;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProxyExtension
implements ProxyExtension {
    private static final Logger log = LoggerFactory.getLogger(KafkaProxyExtension.class);
    private KafkaProxyConfiguration config;

    public String extensionName() {
        return "kafka";
    }

    public boolean accept(String extension) {
        return this.extensionName().equals(extension);
    }

    public void initialize(ProxyConfiguration conf) {
        this.config = new KafkaProxyConfiguration(conf.getProperties());
        log.info("KafkaProxyExtension loaded config: {}", (Object)this.config);
    }

    public void start(ProxyService service) {
        log.info("Starting KafkaProxyExtension, kop version is: '{}'", (Object)KopVersion.getVersion());
        log.info("Git Revision {}", (Object)KopVersion.getGitSha());
        log.info("Built by {} on {} at {}", new Object[]{KopVersion.getBuildUser(), KopVersion.getBuildHost(), KopVersion.getBuildTime()});
    }

    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        return EndPoint.parseListeners((String)this.config.getKafkaListeners()).entrySet().stream().collect(Collectors.toMap(e -> ((EndPoint)e.getValue()).getInetAddress(), e -> new KafkaProxyChannelInitializer((EndPoint)e.getValue())));
    }

    public void close() {
        log.info("KafkaProxyExtension closed.");
    }
}

