/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AddOffsetsToTxnRequest;
import org.apache.kafka.common.requests.AddPartitionsToTxnRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.EndTxnRequest;
import org.apache.kafka.common.requests.HeartbeatRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.JoinGroupRequest;
import org.apache.kafka.common.requests.KopResponseUtils;
import org.apache.kafka.common.requests.LeaveGroupRequest;
import org.apache.kafka.common.requests.OffsetCommitRequest;
import org.apache.kafka.common.requests.OffsetDeleteRequest;
import org.apache.kafka.common.requests.OffsetFetchRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;
import org.apache.kafka.common.requests.SyncGroupRequest;
import org.apache.kafka.common.requests.TxnOffsetCommitRequest;

public class InflightRequest {
    private final CompletableFuture<Object> responseFuture = new CompletableFuture();
    private final RequestHeader header;
    private final AbstractRequest request;
    private final SocketAddress remoteAddress;
    private final ByteBuf buf;
    private Function<Object, Object> responseMapper = __ -> __;
    private boolean skipParsingResponse = false;

    public InflightRequest(ByteBuf buf, SocketAddress remoteAddress) {
        this(buf, remoteAddress, true);
    }

    public InflightRequest(ByteBuf buf, SocketAddress remoteAddress, boolean parseRequest) {
        this.buf = buf.retain();
        this.remoteAddress = remoteAddress;
        ByteBuffer nio = buf.nioBuffer();
        this.header = RequestHeader.parse((ByteBuffer)nio);
        switch (this.header.apiKey()) {
            case API_VERSIONS: {
                if (ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion())) {
                    this.request = AbstractRequest.parseRequest((ApiKeys)this.header.apiKey(), (short)this.header.apiVersion(), (ByteBuffer)nio).request;
                    break;
                }
                this.request = new ApiVersionsRequest.Builder(this.header.apiVersion()).build();
                break;
            }
            case FIND_COORDINATOR: 
            case PRODUCE: 
            case LIST_OFFSETS: 
            case FETCH: {
                if (parseRequest) {
                    this.request = AbstractRequest.parseRequest((ApiKeys)this.header.apiKey(), (short)this.header.apiVersion(), (ByteBuffer)nio).request;
                    break;
                }
                this.request = null;
                break;
            }
            case METADATA: {
                this.request = null;
                break;
            }
            default: {
                this.request = AbstractRequest.parseRequest((ApiKeys)this.header.apiKey(), (short)this.header.apiVersion(), (ByteBuffer)nio).request;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuf toResponseBuf() {
        Object response = this.responseFuture.join();
        if (response instanceof ByteBuf) {
            return (ByteBuf)response;
        }
        if (response instanceof AbstractResponse) {
            short apiVersion = this.header.apiVersion();
            if (this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(apiVersion)) {
                apiVersion = ApiKeys.API_VERSIONS.oldestVersion();
            }
            return KopResponseUtils.serializeResponse((short)apiVersion, (ResponseHeader)this.header.toResponseHeader(), (AbstractResponse)((AbstractResponse)response));
        }
        Pair pair = (Pair)response;
        try {
            ByteBuf byteBuf = KopResponseUtils.serializeResponse((short)this.header.apiVersion(), (ResponseHeader)this.header.toResponseHeader(), (AbstractResponse)((AbstractResponse)pair.getLeft()));
            return byteBuf;
        }
        finally {
            ((List)pair.getValue()).forEach(ReferenceCounted::release);
        }
    }

    public void sendToChannel(Channel channel) {
        channel.writeAndFlush((Object)this.buf);
    }

    public void registerCallback(Runnable callback, Executor executor) {
        this.responseFuture.whenCompleteAsync((__, ___) -> callback.run(), executor);
    }

    public void complete(Object response) {
        this.responseFuture.complete(this.responseMapper.apply(response));
    }

    public void fail(Throwable e) {
        this.responseFuture.completeExceptionally(e);
    }

    public boolean hasReceivedResponse() {
        return this.responseFuture.isDone();
    }

    public boolean hasFailed(Consumer<Throwable> throwableConsumer) {
        if (!this.responseFuture.isCompletedExceptionally()) {
            return false;
        }
        this.responseFuture.exceptionally(e -> {
            throwableConsumer.accept((Throwable)e);
            return null;
        });
        return true;
    }

    public ByteBuf getRetainedBuffer() {
        return this.buf.retain();
    }

    public Object waitForResponse() throws IOException {
        try {
            return this.responseFuture.get();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(this + " is interrupted");
        }
    }

    public <T> CompletableFuture<T> getResponseFuture() {
        return this.responseFuture;
    }

    public String groupId() {
        return switch (this.header.apiKey()) {
            case ApiKeys.JOIN_GROUP -> ((JoinGroupRequest)this.request).data().groupId();
            case ApiKeys.SYNC_GROUP -> ((SyncGroupRequest)this.request).data().groupId();
            case ApiKeys.LEAVE_GROUP -> ((LeaveGroupRequest)this.request).data().groupId();
            case ApiKeys.OFFSET_FETCH -> this.getGroupIdForOffsetFetch((OffsetFetchRequest)this.request);
            case ApiKeys.OFFSET_COMMIT -> ((OffsetCommitRequest)this.request).data().groupId();
            case ApiKeys.HEARTBEAT -> ((HeartbeatRequest)this.request).data().groupId();
            case ApiKeys.TXN_OFFSET_COMMIT -> ((TxnOffsetCommitRequest)this.request).data().groupId();
            case ApiKeys.OFFSET_DELETE -> ((OffsetDeleteRequest)this.request).data().groupId();
            default -> throw new IllegalStateException("Cannot call groupId() for apiKey=" + this.header.apiKey());
        };
    }

    public String txnId() {
        return switch (this.header.apiKey()) {
            case ApiKeys.INIT_PRODUCER_ID -> ((InitProducerIdRequest)this.request).data().transactionalId();
            case ApiKeys.ADD_PARTITIONS_TO_TXN -> ((AddPartitionsToTxnRequest)this.request).data().transactionalId();
            case ApiKeys.ADD_OFFSETS_TO_TXN -> ((AddOffsetsToTxnRequest)this.request).data().transactionalId();
            case ApiKeys.END_TXN -> ((EndTxnRequest)this.request).data().transactionalId();
            default -> throw new IllegalStateException("Cannot call txnId() for apiKey=" + this.header.apiKey());
        };
    }

    private String getGroupIdForOffsetFetch(OffsetFetchRequest request) {
        if (request.version() >= 8) {
            if (request.groupIds().size() > 1) {
                throw new IllegalStateException("KoP proxy does not support v8 OffsetFetch with multiple groups");
            }
            return (String)request.groupIds().get(0);
        }
        return request.groupId();
    }

    public String toString() {
        if (this.request != null) {
            return String.format("InflightRequest(header=%s, request=%s, remoteAddress=%s)", this.header, this.request, this.remoteAddress);
        }
        return String.format("InflightRequest(header=%s, remoteAddress=%s)", this.header, this.remoteAddress);
    }

    public RequestHeader getHeader() {
        return this.header;
    }

    public AbstractRequest getRequest() {
        return this.request;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setResponseMapper(Function<Object, Object> responseMapper) {
        this.responseMapper = responseMapper;
    }

    public boolean isSkipParsingResponse() {
        return this.skipParsingResponse;
    }

    public void setSkipParsingResponse(boolean skipParsingResponse) {
        this.skipParsingResponse = skipParsingResponse;
    }
}

