/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCounted;
import io.streamnative.pulsar.handlers.kop.proxy.ConnectionFactory;
import io.streamnative.pulsar.handlers.kop.proxy.ConnectionToBroker;
import io.streamnative.pulsar.handlers.kop.proxy.InflightRequest;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BrokerConnectionGroup {
    private final ConnectionFactory connectionFactory;
    private final Map<InetSocketAddress, ConnectionToBroker> leaderBrokers = new HashMap<InetSocketAddress, ConnectionToBroker>();
    private final List<ByteBuf> saslRequestBuffers = new ArrayList<ByteBuf>();
    private ConnectionToBroker metadataBroker;
    private ConnectionToBroker groupCoordinator;
    private ConnectionToBroker authenticateBroker;
    private ChannelHandlerContext clientChannel = null;

    public ConnectionToBroker getLeader(InetSocketAddress leader) throws IOException {
        ConnectionToBroker connectionToBroker = this.leaderBrokers.get(leader);
        if (connectionToBroker == null) {
            connectionToBroker = this.connectionFactory.getConnection(leader).withClientChannel(this.clientChannel).forwardRequestsAndWait(this.createSaslRequests());
            this.leaderBrokers.put(leader, connectionToBroker);
        }
        return connectionToBroker;
    }

    public ConnectionToBroker getMetadataBroker() throws IOException {
        if (this.metadataBroker == null) {
            this.metadataBroker = this.connectionFactory.getAnyConnection().withClientChannel(this.clientChannel).forwardRequestsAndWait(this.createSaslRequests());
        }
        return this.metadataBroker;
    }

    public ConnectionToBroker getGroupCoordinator() throws IOException {
        if (this.groupCoordinator == null) {
            this.groupCoordinator = this.connectionFactory.getAnyConnection().withClientChannel(this.clientChannel).forwardRequestsAndWait(this.createSaslRequests());
        }
        return this.groupCoordinator;
    }

    public void authenticate(InflightRequest inflightRequest) throws IOException {
        if (this.authenticateBroker == null) {
            this.authenticateBroker = this.connectionFactory.getAnyConnection();
        }
        this.authenticateBroker.forwardRequest(inflightRequest);
        this.saslRequestBuffers.add(inflightRequest.getRetainedBuffer());
    }

    public void close() {
        this.saslRequestBuffers.forEach(ReferenceCounted::release);
        this.saslRequestBuffers.clear();
        this.clientChannel = null;
        if (this.metadataBroker != null) {
            this.metadataBroker.disconnectBroker();
            this.metadataBroker = null;
        }
        if (this.groupCoordinator != null) {
            this.groupCoordinator.disconnectBroker();
            this.groupCoordinator = null;
        }
        if (this.authenticateBroker != null) {
            this.authenticateBroker.disconnectBroker();
            this.authenticateBroker = null;
        }
        this.leaderBrokers.values().forEach(ConnectionToBroker::disconnectBroker);
        this.leaderBrokers.clear();
    }

    private List<InflightRequest> createSaslRequests() {
        SocketAddress address = this.clientChannel != null ? this.clientChannel.channel().remoteAddress() : InetSocketAddress.createUnresolved("localhost", 65535);
        return this.saslRequestBuffers.stream().map(buffer -> new InflightRequest((ByteBuf)buffer, address)).toList();
    }

    public BrokerConnectionGroup(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void setClientChannel(ChannelHandlerContext clientChannel) {
        this.clientChannel = clientChannel;
    }
}

