/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.KopResponseUtils;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.ResponseHeader;

public class InflightRequest {
    private final CompletableFuture<Object> responseFuture = new CompletableFuture();
    private final RequestHeader header;
    private final AbstractRequest request;
    private final SocketAddress remoteAddress;
    private final ByteBuf buf;
    private Function<Object, Object> responseMapper = __ -> __;

    public InflightRequest(ByteBuf buf, SocketAddress remoteAddress) {
        this.buf = buf.retain();
        this.remoteAddress = remoteAddress;
        ByteBuffer nio = buf.nioBuffer();
        this.header = RequestHeader.parse((ByteBuffer)nio);
        switch (this.header.apiKey()) {
            case API_VERSIONS: {
                if (ApiKeys.API_VERSIONS.isVersionSupported(this.header.apiVersion())) {
                    this.request = AbstractRequest.parseRequest((ApiKeys)this.header.apiKey(), (short)this.header.apiVersion(), (ByteBuffer)nio).request;
                    break;
                }
                this.request = new ApiVersionsRequest.Builder(this.header.apiVersion()).build();
                break;
            }
            case JOIN_GROUP: 
            case SYNC_GROUP: 
            case LEAVE_GROUP: 
            case OFFSET_FETCH: 
            case OFFSET_COMMIT: 
            case HEARTBEAT: {
                this.request = null;
                break;
            }
            default: {
                this.request = AbstractRequest.parseRequest((ApiKeys)this.header.apiKey(), (short)this.header.apiVersion(), (ByteBuffer)nio).request;
            }
        }
    }

    public ByteBuf toResponseBuf() {
        Object response = this.responseFuture.join();
        if (response instanceof ByteBuf) {
            return (ByteBuf)response;
        }
        short apiVersion = this.header.apiVersion();
        if (this.header.apiKey() == ApiKeys.API_VERSIONS && !ApiKeys.API_VERSIONS.isVersionSupported(apiVersion)) {
            apiVersion = ApiKeys.API_VERSIONS.oldestVersion();
        }
        return KopResponseUtils.serializeResponse((short)apiVersion, (ResponseHeader)this.header.toResponseHeader(), (AbstractResponse)((AbstractResponse)response));
    }

    public void sendToChannel(Channel channel) {
        channel.writeAndFlush((Object)this.buf);
    }

    public void registerCallback(Runnable callback, Executor executor) {
        this.responseFuture.whenCompleteAsync((__, ___) -> callback.run(), executor);
    }

    public void complete(Object response) {
        this.responseFuture.complete(this.responseMapper.apply(response));
    }

    public void fail(Throwable e) {
        this.responseFuture.completeExceptionally(e);
    }

    public boolean hasReceivedResponse() {
        return this.responseFuture.isDone();
    }

    public boolean hasFailed(Consumer<Throwable> throwableConsumer) {
        if (!this.responseFuture.isCompletedExceptionally()) {
            return false;
        }
        this.responseFuture.exceptionally(e -> {
            throwableConsumer.accept((Throwable)e);
            return null;
        });
        return true;
    }

    public ByteBuf getRetainedBuffer() {
        return this.buf.retain();
    }

    public void waitForResponse() throws IOException {
        try {
            this.responseFuture.get();
        }
        catch (ExecutionException e) {
            throw new IOException(e.getCause());
        }
        catch (InterruptedException e) {
            throw new IOException(this + " is interrupted");
        }
    }

    public String toString() {
        if (this.request != null) {
            return String.format("InflightRequest(header=%s, request=%s, remoteAddress=%s)", this.header, this.request, this.remoteAddress);
        }
        return String.format("InflightRequest(header=%s, remoteAddress=%s)", this.header, this.remoteAddress);
    }

    public RequestHeader getHeader() {
        return this.header;
    }

    public AbstractRequest getRequest() {
        return this.request;
    }

    public void setResponseMapper(Function<Object, Object> responseMapper) {
        this.responseMapper = responseMapper;
    }
}

