/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.ssl.SslHandler;
import io.streamnative.pulsar.handlers.kop.EndPoint;
import io.streamnative.pulsar.handlers.kop.proxy.ConnectionFactory;
import io.streamnative.pulsar.handlers.kop.proxy.KafkaProxyRequestHandler;
import io.streamnative.pulsar.handlers.kop.utils.ssl.SSLUtils;
import javax.annotation.Nullable;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class KafkaProxyChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final EndPoint advertisedEndPoint;
    private final ConnectionFactory connectionFactory;
    @Nullable
    private final SslContextFactory.Server sslContextFactory;

    protected void initChannel(SocketChannel ch) throws Exception {
        if (this.sslContextFactory != null) {
            ch.pipeline().addLast(new ChannelHandler[]{new SslHandler(SSLUtils.createSslEngine((SslContextFactory.Server)this.sslContextFactory))});
        }
        ch.pipeline().addLast(new ChannelHandler[]{new LengthFieldPrepender(4)});
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x6400000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)new KafkaProxyRequestHandler(this.advertisedEndPoint, this.connectionFactory));
    }

    public KafkaProxyChannelInitializer(EndPoint advertisedEndPoint, ConnectionFactory connectionFactory, @Nullable SslContextFactory.Server sslContextFactory) {
        this.advertisedEndPoint = advertisedEndPoint;
        this.connectionFactory = connectionFactory;
        this.sslContextFactory = sslContextFactory;
    }
}

