/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Properties;

public class KafkaProxyConfiguration {
    public static final String KAFKA_LISTENERS_CONFIG = "kafkaListeners";
    public static final String KAFKA_ADVERTISED_LISTENERS_CONFIG = "kafkaAdvertisedListeners";
    public static final String KAFKA_BOOTSTRAP_SERVERS_CONFIG = "kafkaBootstrapServers";
    private final String kafkaListeners;
    private final String kafkaAdvertisedListeners;
    private final List<InetSocketAddress> kafkaBootstrapServers;
    private int brokerProxyConnectTimeoutMs = 10000;

    public KafkaProxyConfiguration(Properties properties) {
        this.kafkaListeners = properties.getProperty(KAFKA_LISTENERS_CONFIG);
        if (this.kafkaListeners == null || this.kafkaListeners.isEmpty()) {
            throw new IllegalArgumentException("Empty kafkaListeners");
        }
        this.kafkaAdvertisedListeners = Optional.ofNullable(properties.getProperty(KAFKA_ADVERTISED_LISTENERS_CONFIG)).orElse(this.kafkaListeners);
        String value = properties.getProperty(KAFKA_BOOTSTRAP_SERVERS_CONFIG);
        if (value == null) {
            throw new IllegalArgumentException("Empty kafkaBootstrapServers");
        }
        this.kafkaBootstrapServers = new ArrayList<InetSocketAddress>();
        for (String address : value.split(",")) {
            int pos = address.indexOf(58);
            if (pos < 0) {
                throw new IllegalArgumentException("Illegal address " + address);
            }
            this.kafkaBootstrapServers.add(InetSocketAddress.createUnresolved(address.substring(0, pos), Integer.parseInt(address.substring(pos + 1))));
        }
        if (this.kafkaBootstrapServers.isEmpty()) {
            throw new IllegalArgumentException("Empty kafkaListeners");
        }
    }

    public String toString() {
        return String.join((CharSequence)"\n", "kafkaListeners: \"" + this.kafkaListeners + "\"", "kafkaAdvertisedListeners: \"" + this.kafkaAdvertisedListeners + "\"", "kafkaBootstrapServers: \"" + this.kafkaBootstrapServers.stream().map(InetSocketAddress::toString).reduce("", (x, y) -> x + "," + y));
    }

    public String getKafkaListeners() {
        return this.kafkaListeners;
    }

    public String getKafkaAdvertisedListeners() {
        return this.kafkaAdvertisedListeners;
    }

    public List<InetSocketAddress> getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public int getBrokerProxyConnectTimeoutMs() {
        return this.brokerProxyConnectTimeoutMs;
    }

    public void setBrokerProxyConnectTimeoutMs(int brokerProxyConnectTimeoutMs) {
        this.brokerProxyConnectTimeoutMs = brokerProxyConnectTimeoutMs;
    }
}

