/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop.proxy;

import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import io.streamnative.pulsar.handlers.kop.EndPoint;
import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import io.streamnative.pulsar.handlers.kop.KopVersion;
import io.streamnative.pulsar.handlers.kop.proxy.ConnectionFactory;
import io.streamnative.pulsar.handlers.kop.proxy.KafkaProxyChannelInitializer;
import io.streamnative.pulsar.handlers.kop.proxy.KafkaProxyConfiguration;
import io.streamnative.pulsar.handlers.kop.utils.ConfigurationUtils;
import io.streamnative.pulsar.handlers.kop.utils.ssl.SSLUtils;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.pulsar.proxy.extensions.ProxyExtension;
import org.apache.pulsar.proxy.server.ProxyConfiguration;
import org.apache.pulsar.proxy.server.ProxyService;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaProxyExtension
implements ProxyExtension {
    private static final Logger log = LoggerFactory.getLogger(KafkaProxyExtension.class);
    private KafkaProxyConfiguration config;
    private ConnectionFactory connectionFactory;
    private KafkaServiceConfiguration sslConfig;

    public String extensionName() {
        return "kafka";
    }

    public boolean accept(String extension) {
        return this.extensionName().equals(extension);
    }

    public void initialize(ProxyConfiguration conf) {
        this.config = new KafkaProxyConfiguration(conf.getProperties());
        this.config.setBrokerProxyConnectTimeoutMs(conf.getBrokerProxyConnectTimeoutMs());
        this.sslConfig = (KafkaServiceConfiguration)ConfigurationUtils.create((Properties)conf.getProperties(), KafkaServiceConfiguration.class);
        log.info("KafkaProxyExtension loaded config: {}", (Object)this.config);
    }

    public void start(ProxyService service) {
        log.info("Starting KafkaProxyExtension, kop version is: '{}'", (Object)KopVersion.getVersion());
        log.info("Git Revision {}", (Object)KopVersion.getGitSha());
        log.info("Built by {} on {} at {}", new Object[]{KopVersion.getBuildUser(), KopVersion.getBuildHost(), KopVersion.getBuildTime()});
        this.connectionFactory = new ConnectionFactory(this.config, service.getWorkerGroup(), service.getDnsAddressResolverGroup());
    }

    public Map<InetSocketAddress, ChannelInitializer<SocketChannel>> newChannelInitializers() {
        Map listeners = EndPoint.parseListeners((String)this.config.getKafkaListeners());
        Map advertisedListeners = EndPoint.parseListeners((String)this.config.getKafkaAdvertisedListeners());
        if (!listeners.keySet().equals(advertisedListeners.keySet())) {
            throw new RuntimeException("Listener names do not match between kafkaListeners \"" + this.config.getKafkaListeners() + "\" and kafkaAdvertisedListeners \"" + this.config.getKafkaAdvertisedListeners() + "\"");
        }
        return listeners.entrySet().stream().collect(Collectors.toMap(e -> ((EndPoint)e.getValue()).getInetAddress(), e -> {
            EndPoint advertisedEndPoint = (EndPoint)advertisedListeners.get(e.getKey());
            SecurityProtocol securityProtocol = advertisedEndPoint.getSecurityProtocol();
            SslContextFactory.Server sslContextFactory = securityProtocol.equals((Object)SecurityProtocol.SSL) || securityProtocol.equals((Object)SecurityProtocol.SASL_SSL) ? SSLUtils.createSslContextFactory((KafkaServiceConfiguration)this.sslConfig) : null;
            return new KafkaProxyChannelInitializer(advertisedEndPoint, this.connectionFactory, sslContextFactory);
        }));
    }

    public void close() {
        log.info("KafkaProxyExtension closed.");
    }
}

