/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.KafkaServiceConfiguration;
import java.io.Closeable;
import java.util.function.Consumer;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.client.api.AuthenticationFactory;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPulsarClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(AbstractPulsarClient.class);
    private final PulsarClientImpl pulsarClient;

    public AbstractPulsarClient(@NonNull PulsarClientImpl pulsarClient) {
        if (pulsarClient == null) {
            throw new NullPointerException("pulsarClient is marked non-null but is null");
        }
        this.pulsarClient = pulsarClient;
    }

    @Override
    public void close() {
        try {
            this.pulsarClient.close();
        }
        catch (PulsarClientException e) {
            log.warn("Failed to close PulsarClient of {}", (Object)this.getClass().getTypeName(), (Object)e);
        }
    }

    protected static PulsarClientImpl createPulsarClient(PulsarService pulsarService) {
        try {
            return (PulsarClientImpl)pulsarService.getClient();
        }
        catch (PulsarServerException e) {
            log.error("Failed to create PulsarClient", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public static PulsarClientImpl createPulsarClient(PulsarService pulsarService, KafkaServiceConfiguration kafkaConfig, Consumer<ClientConfigurationData> customConfig) {
        ClientConfigurationData conf = new ClientConfigurationData();
        conf.setServiceUrl(kafkaConfig.isTlsEnabled() ? pulsarService.getBrokerServiceUrlTls() : pulsarService.getBrokerServiceUrl());
        conf.setTlsAllowInsecureConnection(kafkaConfig.isTlsAllowInsecureConnection());
        conf.setTlsTrustCertsFilePath(kafkaConfig.getTlsCertificateFilePath());
        if (kafkaConfig.isBrokerClientTlsEnabled()) {
            if (kafkaConfig.isBrokerClientTlsEnabledWithKeyStore()) {
                conf.setUseKeyStoreTls(true);
                conf.setTlsTrustStoreType(kafkaConfig.getBrokerClientTlsTrustStoreType());
                conf.setTlsTrustStorePath(kafkaConfig.getBrokerClientTlsTrustStore());
                conf.setTlsTrustStorePassword(kafkaConfig.getBrokerClientTlsTrustStorePassword());
            } else {
                conf.setTlsTrustCertsFilePath(StringUtils.isNotBlank((CharSequence)kafkaConfig.getBrokerClientTrustCertsFilePath()) ? kafkaConfig.getBrokerClientTrustCertsFilePath() : kafkaConfig.getTlsCertificateFilePath());
            }
        }
        try {
            if (StringUtils.isNotBlank((CharSequence)kafkaConfig.getBrokerClientAuthenticationPlugin())) {
                conf.setAuthPluginClassName(kafkaConfig.getBrokerClientAuthenticationPlugin());
                conf.setAuthParams(kafkaConfig.getBrokerClientAuthenticationParameters());
                conf.setAuthParamMap(null);
                conf.setAuthentication(AuthenticationFactory.create((String)kafkaConfig.getBrokerClientAuthenticationPlugin(), (String)kafkaConfig.getBrokerClientAuthenticationParameters()));
            }
            customConfig.accept(conf);
            return new PulsarClientImpl(conf);
        }
        catch (PulsarClientException e) {
            log.error("Failed to create PulsarClient", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    public PulsarClientImpl getPulsarClient() {
        return this.pulsarClient;
    }
}

