/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import com.google.common.base.Preconditions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.validator.routines.InetAddressValidator;

public class AdvertisedListener {
    private static final String REGEX = "^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)";
    private static final Pattern PATTERN = Pattern.compile("^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)");
    private final String originalListener;
    private final String listenerName;
    private final String hostname;
    private final int port;

    public static AdvertisedListener create(String listener) {
        return new AdvertisedListener(listener);
    }

    public AdvertisedListener(String listener) {
        this.originalListener = listener;
        String errorMessage = "Listener '" + listener + "' is invalid";
        Matcher matcher = AdvertisedListener.matcherListener(listener, errorMessage);
        this.listenerName = matcher.group(1);
        this.port = Integer.parseInt(matcher.group(3), 10);
        Preconditions.checkState((this.port >= 0 && this.port <= 65535 ? 1 : 0) != 0, (Object)(errorMessage + ": port '" + this.port + "' is invalid."));
        String hostname = matcher.group(2);
        if (hostname.isEmpty()) {
            try {
                this.hostname = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Hostname is empty and localhost is unknown: " + e.getMessage());
            }
        } else if (InetAddressValidator.getInstance().isValidInet6Address(hostname)) {
            try {
                this.hostname = InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new IllegalStateException("Hostname is invalid: " + e.getMessage());
            }
        } else {
            this.hostname = hostname;
        }
    }

    public static Matcher matcherListener(String listener, String errorMessage) {
        Matcher matcher = PATTERN.matcher(listener);
        Preconditions.checkState((boolean)matcher.find(), (Object)errorMessage);
        Preconditions.checkState((matcher.groupCount() == 3 ? 1 : 0) != 0, (Object)errorMessage);
        return matcher;
    }

    public String getOriginalListener() {
        return this.originalListener;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }
}

