/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import io.streamnative.pulsar.handlers.kop.utils.delayed.DelayedOperation;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class DelayedProduceAndFetch
extends DelayedOperation {
    private final AtomicInteger topicPartitionNum;
    private final Runnable callback;

    public DelayedProduceAndFetch(long delayMs, AtomicInteger topicPartitionNum, Runnable callback) {
        super(delayMs, Optional.empty());
        this.topicPartitionNum = topicPartitionNum;
        this.callback = callback;
    }

    @Override
    public void onExpiration() {
        this.callback.run();
    }

    @Override
    public void onComplete() {
        this.callback.run();
    }

    @Override
    public boolean tryComplete() {
        if (this.topicPartitionNum.get() <= 0) {
            this.forceComplete();
            return true;
        }
        return false;
    }
}

