/*
 * Decompiled with CFR 0.152.
 */
package io.streamnative.pulsar.handlers.kop;

import com.google.common.annotations.VisibleForTesting;
import io.streamnative.pulsar.handlers.kop.AdvertisedListener;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class EndPoint {
    public static final String END_POINT_SEPARATOR = ",";
    private static final String PROTOCOL_MAP_SEPARATOR = ",";
    private static final String PROTOCOL_SEPARATOR = ":";
    private final String originalListener;
    private final String listenerName;
    private final SecurityProtocol securityProtocol;
    private final String hostname;
    private final int port;
    private final boolean validInProtocolMap;
    private final boolean tlsEnabled;

    public EndPoint(String listener, Map<String, SecurityProtocol> protocolMap) {
        this.originalListener = listener;
        AdvertisedListener advertisedListener = AdvertisedListener.create(listener);
        this.listenerName = advertisedListener.getListenerName();
        this.hostname = advertisedListener.getHostname();
        this.port = advertisedListener.getPort();
        if (protocolMap == null || protocolMap.isEmpty()) {
            this.validInProtocolMap = false;
            this.securityProtocol = SecurityProtocol.forName((String)this.listenerName);
        } else {
            this.validInProtocolMap = true;
            this.securityProtocol = protocolMap.get(this.listenerName);
            if (this.securityProtocol == null) {
                throw new IllegalStateException(this.listenerName + " is not set in kafkaProtocolMap");
            }
        }
        this.tlsEnabled = this.securityProtocol == SecurityProtocol.SSL || this.securityProtocol == SecurityProtocol.SASL_SSL;
    }

    public InetSocketAddress getInetAddress() {
        return new InetSocketAddress(this.hostname, this.port);
    }

    private static String[] getListenerArray(String listeners) {
        if (StringUtils.isEmpty((CharSequence)listeners)) {
            throw new IllegalStateException("listeners is empty");
        }
        String[] listenerArray = listeners.split(",");
        if (listenerArray.length == 0) {
            throw new IllegalStateException(listeners + " is split into 0 tokens by ,");
        }
        return listenerArray;
    }

    @VisibleForTesting
    public static Map<String, EndPoint> parseListeners(String listeners) {
        return EndPoint.parseListeners(listeners, "");
    }

    private static Map<String, EndPoint> parseListeners(String listeners, Map<String, SecurityProtocol> protocolMap) {
        HashMap<String, EndPoint> endPointMap = new HashMap<String, EndPoint>();
        for (String listener : EndPoint.getListenerArray(listeners)) {
            EndPoint endPoint = new EndPoint(listener, protocolMap);
            if (endPointMap.containsKey(endPoint.listenerName)) {
                throw new IllegalStateException(listeners + " has multiple listeners whose listenerName is " + endPoint.listenerName);
            }
            endPointMap.put(endPoint.listenerName, endPoint);
        }
        return endPointMap;
    }

    @VisibleForTesting
    public static Map<String, EndPoint> parseListeners(String listeners, String protocolMapString) {
        return EndPoint.parseListeners(listeners, EndPoint.parseProtocolMap(protocolMapString));
    }

    public static String findListener(String listeners, String name) {
        if (name == null) {
            return null;
        }
        for (String listener : EndPoint.getListenerArray(listeners)) {
            if (!listener.contains(PROTOCOL_SEPARATOR) || !listener.substring(0, listener.indexOf(PROTOCOL_SEPARATOR)).equals(name)) continue;
            return listener;
        }
        throw new IllegalStateException("listener \"" + name + "\" doesn't exist in " + listeners);
    }

    public static String findFirstListener(String listeners) {
        return EndPoint.getListenerArray(listeners)[0];
    }

    public static EndPoint getPlainTextEndPoint(String listeners) {
        for (String listener : listeners.split(",")) {
            if (!listener.startsWith(SecurityProtocol.PLAINTEXT.name()) && !listener.startsWith(SecurityProtocol.SASL_PLAINTEXT.name())) continue;
            return new EndPoint(listener, null);
        }
        throw new IllegalStateException(listeners + " has no plain text endpoint");
    }

    public static EndPoint getSslEndPoint(String listeners) {
        for (String listener : listeners.split(",")) {
            if (!listener.startsWith(SecurityProtocol.SSL.name()) && !listener.startsWith(SecurityProtocol.SASL_SSL.name())) continue;
            return new EndPoint(listener, null);
        }
        throw new IllegalStateException(listeners + " has no ssl endpoint");
    }

    public static Map<String, SecurityProtocol> parseProtocolMap(String kafkaProtocolMap) {
        if (StringUtils.isEmpty((CharSequence)kafkaProtocolMap)) {
            return Collections.emptyMap();
        }
        HashMap<String, SecurityProtocol> protocolMap = new HashMap<String, SecurityProtocol>();
        for (String protocolSet : kafkaProtocolMap.split(",")) {
            String[] protocol = protocolSet.split(PROTOCOL_SEPARATOR);
            if (protocol.length != 2) {
                throw new IllegalStateException("wrong format for kafkaProtocolMap " + kafkaProtocolMap);
            }
            if (protocolMap.containsKey(protocol[0])) {
                throw new IllegalStateException(kafkaProtocolMap + " has multiple listeners whose listenerName is " + protocol[0]);
            }
            protocolMap.put(protocol[0], SecurityProtocol.forName((String)protocol[1]));
        }
        return protocolMap;
    }

    public String getOriginalListener() {
        return this.originalListener;
    }

    public String getListenerName() {
        return this.listenerName;
    }

    public SecurityProtocol getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isValidInProtocolMap() {
        return this.validInProtocolMap;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }
}

